/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import tk.shanebee.bee.elements.bound.objects.Bound;

@Name(value="Bound - Blocks")
@Description(value={"All the blocks within a bound"})
@Examples(value={"set {_blocks::*} to all blocks within bound {bound}", "set all blocks within {bound} to stone", "loop all blocks within bound {bound}:", "\tif loop-block is stone:", "\t\tset loop-block to grass"})
@Since(value="1.0.0")
public class ExprBoundBlocks
extends SimpleExpression<Block> {
    private Expression<Bound> bound;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.bound = exprs[0];
        return true;
    }

    protected Block[] get(Event event) {
        ArrayList<Block> list = new ArrayList<Block>(((Bound)this.bound.getSingle(event)).getBlocks());
        return list.toArray(new Block[0]);
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(Event e, boolean d) {
        return "the blocks within bound " + this.bound.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundBlocks.class, Block.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(all [[of] the]|the)] blocks within [bound] %bound%"});
    }
}

