/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT.utils.nmsmappings;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import tk.shanebee.bee.api.NBT.utils.MinecraftVersion;
import tk.shanebee.bee.api.NBT.utils.nmsmappings.PackageWrapper;

public enum ClassWrapper {
    CRAFT_ITEMSTACK(PackageWrapper.CRAFTBUKKIT, "inventory.CraftItemStack"),
    CRAFT_ENTITY(PackageWrapper.CRAFTBUKKIT, "entity.CraftEntity"),
    CRAFT_WORLD(PackageWrapper.CRAFTBUKKIT, "CraftWorld"),
    NMS_NBTBASE(PackageWrapper.NMS, "NBTBase"),
    NMS_NBTTAGSTRING(PackageWrapper.NMS, "NBTTagString"),
    NMS_NBTTAGINT(PackageWrapper.NMS, "NBTTagInt"),
    NMS_NBTTAGFLOAT(PackageWrapper.NMS, "NBTTagFloat"),
    NMS_NBTTAGDOUBLE(PackageWrapper.NMS, "NBTTagDouble"),
    NMS_NBTTAGLONG(PackageWrapper.NMS, "NBTTagLong"),
    NMS_ITEMSTACK(PackageWrapper.NMS, "ItemStack"),
    NMS_NBTTAGCOMPOUND(PackageWrapper.NMS, "NBTTagCompound"),
    NMS_NBTTAGLIST(PackageWrapper.NMS, "NBTTagList"),
    NMS_NBTCOMPRESSEDSTREAMTOOLS(PackageWrapper.NMS, "NBTCompressedStreamTools"),
    NMS_MOJANGSONPARSER(PackageWrapper.NMS, "MojangsonParser"),
    NMS_TILEENTITY(PackageWrapper.NMS, "TileEntity"),
    NMS_BLOCKPOSITION(PackageWrapper.NMS, "BlockPosition"),
    NMS_WORLDSERVER(PackageWrapper.NMS, "WorldServer"),
    NMS_MINECRAFTSERVER(PackageWrapper.NMS, "MinecraftServer"),
    NMS_WORLD(PackageWrapper.NMS, "World"),
    NMS_ENTITY(PackageWrapper.NMS, "Entity"),
    NMS_ENTITYTYPES(PackageWrapper.NMS, "EntityTypes"),
    NMS_REGISTRYSIMPLE(PackageWrapper.NMS, "RegistrySimple", MinecraftVersion.MC1_11_R1, MinecraftVersion.MC1_12_R1),
    NMS_REGISTRYMATERIALS(PackageWrapper.NMS, "RegistryMaterials"),
    NMS_IREGISTRY(PackageWrapper.NMS, "IRegistry"),
    NMS_MINECRAFTKEY(PackageWrapper.NMS, "MinecraftKey"),
    NMS_GAMEPROFILESERIALIZER(PackageWrapper.NMS, "GameProfileSerializer");

    private Class<?> clazz;
    private boolean enabled = false;

    private ClassWrapper(PackageWrapper packageId, String suffix) {
        this(packageId, suffix, null, null);
    }

    private ClassWrapper(PackageWrapper packageId, String suffix, MinecraftVersion from, MinecraftVersion to) {
        if (from != null && MinecraftVersion.getVersion().getVersionId() < from.getVersionId()) {
            return;
        }
        if (to != null && MinecraftVersion.getVersion().getVersionId() > to.getVersionId()) {
            return;
        }
        this.enabled = true;
        try {
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            this.clazz = Class.forName(packageId.getUri() + "." + version + "." + suffix);
        }
        catch (Exception ex) {
            MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] Error while trying to resolve the class '" + suffix + "'!", ex);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

