/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.config.Config;
import tk.shanebee.bee.elements.recipe.util.RecipeUtil;

@Name(value="Recipe - Shaped/Shapeless")
@Description(value={"Register a new shaped/shapeless recipe for a specific item using custom ingredients. The ID will be the name given to this recipe. IDs may only contain letters, numbers, periods, hyphens and underscores. Used for recipe discovery/unlocking recipes for players. You may also include an optional group for recipes. These will group the recipes together in the recipe book. <b>NOTE:</b> Recipes with 4 or less ingredients will be craftable in the player's crafting grid.", "By default recipes will start with the namespace \"skrecipe:\", this can be changed in the config to whatever you want."})
@Examples(value={"on load:", "\tregister new shaped recipe for elytra using air, iron chestplate, air, air, iron chestplate and air with id \"elytra\"", "\tset {_strong} to emerald named \"&3Strong Emerald\"", "\tregister new shaped recipe for {_strong} using emerald, emerald, air, emerald, emerald and air with id \"strong_emerald\"", "\tregister new shaped recipe for diamond chestplate named \"&3Strong Emerald Chestplate\" using {_strong}, air, {_strong}, {_strong}, {_strong}, {_strong}, {_strong}, {_strong} and {_strong} with id \"strong_emerald_chestplate\""})
@RequiredPlugins(value={"1.13+"})
@Since(value="1.0.0")
public class EffCraftingRecipe
extends Effect {
    private final Config config = SkBee.getPlugin().getPluginConfig();
    private Expression<ItemType> item;
    private Expression<ItemType> ingredients;
    private Expression<String> key;
    private Expression<String> group;
    private boolean shaped;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        this.ingredients = exprs[1];
        this.key = exprs[2];
        this.group = exprs[3];
        this.shaped = parseResult.mark == 0;
        return true;
    }

    protected void execute(Event event) {
        ItemType item = (ItemType)this.item.getSingle(event);
        ItemType[] ingredients = (ItemType[])this.ingredients.getAll(event);
        if (item == null) {
            RecipeUtil.error("Error registering crafting recipe - result is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (ingredients == null) {
            RecipeUtil.error("Error registering crafting recipe - ingredient is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        String group = this.group != null ? (String)this.group.getSingle(event) : null;
        NamespacedKey key = RecipeUtil.getKey((String)this.key.getSingle(event));
        RecipeUtil.removeRecipe(key);
        if (this.shaped) {
            this.registerShaped(item, ingredients, key, group);
        } else {
            this.registerShapeless(item, ingredients, key, group);
        }
    }

    private void registerShaped(ItemType item, ItemType[] ingredients, NamespacedKey key, String group) {
        String two;
        String one;
        boolean craftingTable = ingredients.length > 4;
        ShapedRecipe recipe = new ShapedRecipe(key, item.getRandom());
        if (group != null) {
            recipe.setGroup(group);
        }
        Character[] oldChar = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        Character[] keyChar = new Character[9];
        for (int i = 0; i < 9; ++i) {
            keyChar[i] = ingredients.length - 1 < i ? Character.valueOf(' ') : (ingredients[i].getMaterial() == Material.AIR ? Character.valueOf(' ') : oldChar[i]);
        }
        if (craftingTable) {
            one = String.valueOf(keyChar[0]) + keyChar[1] + keyChar[2];
            two = String.valueOf(keyChar[3]) + keyChar[4] + keyChar[5];
            String three = String.valueOf(keyChar[6]) + keyChar[7] + keyChar[8];
            recipe.shape(new String[]{one, two, three});
        } else {
            one = String.valueOf(keyChar[0]) + keyChar[1];
            two = String.valueOf(keyChar[2]) + keyChar[3];
            recipe.shape(new String[]{one, two});
        }
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i].getMaterial() == Material.AIR) continue;
            recipe.setIngredient(keyChar[i].charValue(), (RecipeChoice)new RecipeChoice.ExactChoice(ingredients[i].getRandom()));
        }
        if (this.config.SETTINGS_DEBUG) {
            RecipeUtil.logRecipe((Recipe)recipe, recipe.getIngredientMap().toString());
        }
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerShapeless(ItemType item, ItemType[] ingredients, NamespacedKey key, String group) {
        ShapelessRecipe recipe = new ShapelessRecipe(key, item.getRandom());
        if (group != null) {
            recipe.setGroup(group);
        }
        for (ItemType ingredient : ingredients) {
            if (ingredient.getMaterial() != Material.AIR && ingredient.getMaterial().isItem()) {
                recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(ingredient.getRandom()));
                continue;
            }
            if (!this.config.SETTINGS_DEBUG) continue;
            RecipeUtil.warn("ERROR LOADING RECIPE:");
            RecipeUtil.warn("Non item &b" + ingredient + "&e found in recipe with ID &b" + key.getKey() + "&e, this item will be removed from the recipe.");
        }
        Bukkit.addRecipe((Recipe)recipe);
        if (this.config.SETTINGS_DEBUG) {
            RecipeUtil.logRecipe((Recipe)recipe, recipe.getIngredientList().toString());
        }
    }

    public String toString(Event e, boolean d) {
        String shape = this.shaped ? "shaped" : "shapeless";
        String group = this.group != null ? " in group " + this.group.toString(e, d) : "";
        return "Register new " + shape + " recipe for " + this.item.toString(e, d) + " using " + this.ingredients.toString(e, d) + " with id " + this.key.toString(e, d) + group;
    }

    static {
        Skript.registerEffect(EffCraftingRecipe.class, (String[])new String[]{"register [new] (0\u00a6shaped|1\u00a6shapeless) recipe for %itemtype% (using|with ingredients) %itemtypes% with id %string% [in group %-string%]"});
    }
}

