/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.bound.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.elements.bound.config.BoundConfig;
import tk.shanebee.bee.elements.bound.objects.Bound;

@Name(value="Bound - Create/Remove")
@Description(value={"Create/Remove a bound with id between 2 locations. Optional value \"full\" is a bound from Y=0 to max height of world."})
@Examples(value={"create a new bound with id \"%uuid of player%.home\" between {loc1} and {loc2}", "create a full bound with id \"spawn\" between {loc} and location of player", "delete bound with id \"my.home\""})
@Since(value="1.0.0")
public class EffBoundCreate
extends Effect {
    private static final BoundConfig boundConfig = SkBee.getPlugin().getBoundConfig();
    private Expression<String> id;
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private boolean create;
    private boolean full;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        boolean bl = this.create = matchedPattern == 0;
        if (this.create) {
            this.full = parseResult.mark == 1;
            this.loc1 = exprs[1];
            this.loc2 = exprs[2];
        }
        return true;
    }

    protected void execute(Event event) {
        if (this.id.getSingle(event) == null) {
            return;
        }
        String id = (String)this.id.getSingle(event);
        if (this.create) {
            Location lesser = (Location)this.loc1.getSingle(event);
            Location greater = (Location)this.loc2.getSingle(event);
            if (this.full) {
                World w = greater.getWorld();
                assert (w != null);
                int max = w.getMaxHeight() - 1;
                lesser.setY(0.0);
                greater.setY((double)max);
            }
            Bound bound = new Bound(lesser, greater, id);
            boundConfig.saveBound(bound);
        } else {
            Bound bound = boundConfig.getBoundFromID(id);
            if (bound != null) {
                boundConfig.removeBound(bound);
            }
        }
    }

    public String toString(Event e, boolean d) {
        String type = this.create ? "create" : "delete";
        String full = this.full ? " full " : " ";
        String create = this.create ? " between " + this.loc1.toString(e, d) + " and " + this.loc2.toString(e, d) : "";
        return type + full + "bound with id " + this.id.toString(e, d) + create;
    }

    static {
        Skript.registerEffect(EffBoundCreate.class, (String[])new String[]{"create [a] [new] [(1\u00a6full)] bound with id %string% (within|between) %location% and %location%", "(delete|remove) bound with id %string%"});
    }
}

