/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import tk.shanebee.bee.api.NBTApi;
import tk.shanebee.bee.api.listener.BoundBorderListener;
import tk.shanebee.bee.config.Config;
import tk.shanebee.bee.elements.board.listener.PlayerBoardListener;
import tk.shanebee.bee.elements.bound.config.BoundConfig;
import tk.shanebee.bee.elements.bound.objects.Bound;
import tk.shanebee.bee.metrics.Metrics;

public class SkBee
extends JavaPlugin {
    private static SkBee instance;
    private NBTApi nbtApi;
    private PluginManager pm;
    private Config config;
    private BoundConfig boundConfig = null;
    private SkriptAddon addon;

    public void onEnable() {
        instance = this;
        this.nbtApi = new NBTApi();
        this.pm = Bukkit.getPluginManager();
        this.config = new Config(this);
        PluginDescriptionFile desc = this.getDescription();
        if (this.pm.getPlugin("Skript") != null && Skript.isAcceptRegistrations()) {
            this.addon = Skript.registerAddon((JavaPlugin)this);
            this.loadNBTElements();
            this.loadRecipeElements();
            this.loadBoardElements();
            this.loadBoundElements();
            this.loadStructureElements();
            this.loadOtherElements();
            if (desc.getVersion().contains("Beta")) {
                SkBee.log("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub");
                SkBee.log("&ehttps://github.com/ShaneBeee/SkBee/issues");
            }
        } else {
            SkBee.log("&cDependency Skript was not found, plugin disabling");
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        this.loadMetrics();
        SkBee.log("&aSuccessfully enabled v" + desc.getVersion());
    }

    private void loadNBTElements() {
        if (!this.config.ELEMENTS_NBT) {
            SkBee.log("&5NBT Elements &cdisabled via config");
            return;
        }
        try {
            this.addon.loadClasses("tk.shanebee.bee.elements.nbt", new String[0]);
            this.nbtApi.forceLoadNBT();
            SkBee.log("&5NBT Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadRecipeElements() {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            if (!this.config.ELEMENTS_RECIPE) {
                SkBee.log("&5Recipe Elements &cdisabled via config");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.recipe", new String[0]);
                SkBee.log("&5Recipe Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            SkBee.log("&5Recipe Elements &cdisabled");
            SkBee.log("&7 - Recipe elements are only available on 1.13+");
        }
    }

    private void loadBoardElements() {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            if (!this.config.ELEMENTS_BOARD) {
                SkBee.log("&5Scoreboard Elements &cdisabled via config");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.board", new String[0]);
                this.pm.registerEvents((Listener)new PlayerBoardListener(), (Plugin)this);
                SkBee.log("&5Scoreboard Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            SkBee.log("&5Scoreboard Elements &cdisabled");
            SkBee.log("&7 - Scoreboard elements are only available on 1.13+");
        }
    }

    private void loadBoundElements() {
        if (!this.config.ELEMENTS_BOUND) {
            SkBee.log("&5Bound Elements &cdisabled via config");
            return;
        }
        try {
            this.boundConfig = new BoundConfig(this);
            this.pm.registerEvents((Listener)new BoundBorderListener(this), (Plugin)this);
            this.addon.loadClasses("tk.shanebee.bee.elements.bound", new String[0]);
            SkBee.log("&5Bound Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadStructureElements() {
        if (Skript.isRunningMinecraft((int)1, (int)9, (int)4)) {
            if (!this.config.ELEMENTS_STRUCTURE) {
                SkBee.log("&5Structure Elements &cdisabled via config");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.structure", new String[0]);
                SkBee.log("&5Structure Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            SkBee.log("&5Structure Elements &cdisabled");
            SkBee.log("&7 - Structure elements are only available on 1.9.4+");
        }
    }

    private void loadOtherElements() {
        try {
            this.addon.loadClasses("tk.shanebee.bee.elements.other", new String[0]);
            SkBee.log("&5Other Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 6719);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }

    public void onDisable() {
    }

    public static SkBee getPlugin() {
        return instance;
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public BoundConfig getBoundConfig() {
        return this.boundConfig;
    }

    public NBTApi getNbtApi() {
        return this.nbtApi;
    }

    public static void log(String log) {
        String prefix = "&7[&bSk&3Bee&7] ";
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + log)));
    }

    static {
        ConfigurationSerialization.registerClass(Bound.class, (String)"Bound");
    }
}

