/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.Bukkit;

public class Remover {
    private final String VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    private final Constructor<?> keyConstructor;
    private final Map<?, Map<?, ?>> recipeMap;

    public Remover() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> MC_KEY = this.getNMSClass("MinecraftKey");
        this.keyConstructor = MC_KEY.getDeclaredConstructor(String.class);
        this.recipeMap = this.getRecipeMap();
    }

    public void removeRecipeByKey(String recipeKey) {
        Object key;
        if (recipeKey.equals("*")) {
            this.removeAll();
            return;
        }
        try {
            key = this.keyConstructor.newInstance(recipeKey);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return;
        }
        this.recipeMap.values().forEach(recipes -> recipes.entrySet().removeIf(entry -> entry.getKey().equals(key)));
    }

    public void removeAll() {
        this.recipeMap.values().forEach(recipes -> recipes.entrySet().removeIf(entry -> entry.getKey().toString().contains("minecraft:")));
    }

    private Map<?, Map<?, ?>> getRecipeMap() {
        try {
            Class<?> CRAFT_SERVER = this.getCBClass("CraftServer");
            Method getServer = CRAFT_SERVER.getMethod("getServer", new Class[0]);
            Object dediServer = getServer.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> DEDI_SERVER = this.getNMSClass("DedicatedServer");
            Method getCraftingManager = DEDI_SERVER.getMethod("getCraftingManager", new Class[0]);
            Object craftingManager = getCraftingManager.invoke(dediServer, new Object[0]);
            Class<?> CRAFTING_MANAGER = this.getNMSClass("CraftingManager");
            Field recipeField = CRAFTING_MANAGER.getField("recipes");
            return (Map)recipeField.get(craftingManager);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class<?> getNMSClass(String nmsClassString) throws ClassNotFoundException {
        String name = "net.minecraft.server." + this.VERSION + "." + nmsClassString;
        return Class.forName(name);
    }

    private Class<?> getCBClass(String cbClassString) throws ClassNotFoundException {
        String name = "org.bukkit.craftbukkit." + this.VERSION + "." + cbClassString;
        return Class.forName(name);
    }
}

