/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api;

import ch.njol.skript.aliases.ItemType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTEntity;
import tk.shanebee.bee.api.NBT.NBTFile;
import tk.shanebee.bee.api.NBT.NBTItem;
import tk.shanebee.bee.api.NBT.NBTTileEntity;
import tk.shanebee.bee.api.NBT.NBTType;
import tk.shanebee.bee.api.Reflection;

public class NBTApi {
    public void forceLoadNBT() {
        SkBee.log("&aLoading NBTApi!");
        NBTItem loadingItem = new NBTItem(new ItemStack(Material.STONE));
        loadingItem.mergeCompound(new NBTContainer("{}"));
        SkBee.log("&aNBTApi successfully loaded!");
    }

    public void setNBT(ItemType itemType, String value) {
        ItemStack itemStack = new ItemStack(itemType.getMaterial());
        NBTItem item = new NBTItem(itemStack);
        item.mergeCompound(new NBTContainer(value));
        Reflection.setMeta(itemType, item.getItem().getItemMeta());
    }

    public void setNBT(ItemStack itemStack, String value) {
        ItemStack stack = new ItemStack(itemStack.getType());
        NBTItem item = new NBTItem(stack);
        item.mergeCompound(new NBTContainer(value));
        itemStack.setItemMeta(item.getItem().getItemMeta());
    }

    public void addNBT(ItemType itemType, String value) {
        ItemStack stack = itemType.getRandom();
        if (stack == null) {
            return;
        }
        NBTItem item = new NBTItem(stack);
        item.mergeCompound(new NBTContainer(value));
        Reflection.setMeta(itemType, item.getItem().getItemMeta());
    }

    public void addNBT(ItemStack itemStack, String value) {
        NBTItem item = new NBTItem(itemStack);
        item.mergeCompound(new NBTContainer(value));
        itemStack.setItemMeta(item.getItem().getItemMeta());
    }

    public String getNBT(ItemType itemType) {
        ItemStack itemStack = itemType.getRandom();
        if (itemStack == null) {
            return null;
        }
        NBTItem item = new NBTItem(itemType.getRandom());
        return item.toString();
    }

    public String getNBT(ItemStack itemStack) {
        NBTItem item = new NBTItem(itemStack);
        return item.toString();
    }

    public void setNBT(Entity entity, String newValue) {
        this.addNBT(entity, newValue);
    }

    public void addNBT(Entity entity, String newValue) {
        NBTEntity nbtEntity = new NBTEntity(entity);
        nbtEntity.mergeCompound(new NBTContainer(newValue));
    }

    public String getNBT(Entity entity) {
        NBTEntity nbtEntity = new NBTEntity(entity);
        return nbtEntity.toString();
    }

    public void setNBT(Block block, String newValue) {
        this.addNBT(block, newValue);
    }

    public void addNBT(Block block, String newValue) {
        NBTTileEntity tile = new NBTTileEntity(block.getState());
        tile.mergeCompound(new NBTContainer(newValue));
    }

    public String getNBT(Block block) {
        NBTTileEntity tile = new NBTTileEntity(block.getState());
        return tile.toString();
    }

    public String getNBT(String fileName) {
        File file = this.getFile(fileName);
        if (file == null) {
            return null;
        }
        NBTFile fileNBT = null;
        try {
            fileNBT = new NBTFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fileNBT == null) {
            return null;
        }
        return fileNBT.toString();
    }

    public void addNBT(String file, String value) {
        File file1 = this.getFile(file);
        if (file1 == null) {
            return;
        }
        try {
            NBTFile nbtFile = new NBTFile(file1);
            nbtFile.mergeCompound(new NBTContainer(value));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setNBT(String file, String value) {
        this.addNBT(file, value);
    }

    private File getFile(String fileName) {
        File file = new File(fileName = !fileName.endsWith(".dat") ? fileName + ".dat" : fileName);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public Object getTag(String tag, String nbt) {
        NBTContainer compound = new NBTContainer(nbt);
        NBTType type = compound.getType(tag);
        switch (compound.getType(tag)) {
            case NBTTagString: {
                return compound.getString(tag);
            }
            case NBTTagInt: {
                return compound.getInteger(tag);
            }
            case NBTTagFloat: {
                return compound.getFloat(tag);
            }
            case NBTTagShort: {
                return compound.getShort(tag);
            }
            case NBTTagDouble: {
                return compound.getDouble(tag);
            }
            case NBTTagLong: {
                return compound.getLong(tag);
            }
            case NBTTagByte: {
                return compound.getByte(tag);
            }
            case NBTTagCompound: 
            case NBTTagList: {
                ArrayList<String> string = new ArrayList<String>();
                for (NBTCompound compound1 : compound.getCompoundList(tag)) {
                    string.add(compound1.toString());
                }
                return string;
            }
        }
        return "null -> type: " + type.toString();
    }
}

