/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skaddonlib.util;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;

public class SimpleEnumClassInfo<E extends Enum<E>> {
    private final Class<E> enumType;
    private final String codeName;
    private final ClassInfo<E> classInfo;

    private SimpleEnumClassInfo(Class<E> enumType, String codeName) {
        this.enumType = enumType;
        this.codeName = codeName;
        this.classInfo = new ClassInfo(enumType, codeName);
    }

    public static <E extends Enum<E>> SimpleEnumClassInfo<E> create(Class<E> enumType, String codeName) {
        return new SimpleEnumClassInfo<E>(enumType, codeName);
    }

    public void register() {
        Classes.registerClass((ClassInfo)this.classInfo.user(new String[]{this.codeName + "s?"}).parser(new Parser<E>(){

            public E parse(String s, ParseContext parseContext) {
                try {
                    return Enum.valueOf(SimpleEnumClassInfo.this.enumType, s.replace(" ", "_").toUpperCase().trim());
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            public String toString(E e, int i) {
                return ((Enum)e).toString();
            }

            public String toVariableNameString(E e) {
                return SimpleEnumClassInfo.this.codeName + ':' + ((Enum)e).toString();
            }

            public String getVariableNamePattern() {
                return SimpleEnumClassInfo.this.codeName + ":+.";
            }
        }));
    }
}

