/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.permPlugins.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;
import tk.shanebee.skperm.utils.api.API;

@Name(value="Permission: Permissions of Group")
@Description(value={"Returns a list of all the group's permissions with an option to get the permissions for a specific world. You can also add/remove permissions to/from a group (Supports lists of permissions/strings) [Support for timed permissions does not seem to be working. This is an issue with PEX. May or may not work] [Requires a permission plugin, Currently supports PEX, LuckPerms and UltraPermissions]"})
@Examples(value={"set {_perms::*} to all permissions of group \"mod\"", "set {_perms::*} to all permissions of group \"builder\" in world \"world\"", "send \"Perms in %world of player%: %all permissions of group \"\"admin\"\" in world of player%\"", "add \"essentials.fly\" to permissions of group \"builder\" in world \"world\"", "remove \"essentials.fly\" from permissions of group \"mod\""})
@Since(value="2.0.0")
public class ExprGroupPerms
extends SimpleExpression<String> {
    private API api = SkPerm.getAPI();
    private Expression<String> group;
    private Expression<World> world;
    private Expression<Timespan> time;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = exprs[0];
        this.world = exprs[1];
        this.time = exprs[2];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        int sec;
        String[] perms = delta == null ? null : (String[])Arrays.copyOf(delta, delta.length, String[].class);
        String group = (String)this.group.getSingle(e);
        World world = this.world == null ? null : (World)this.world.getSingle(e);
        int n = sec = this.time == null ? 0 : (int)((Timespan)this.time.getSingle(e)).getTicks_i() / 20;
        if (perms == null) {
            return;
        }
        block4: for (String perm : perms) {
            switch (mode) {
                case ADD: {
                    if (sec == 0) {
                        if (world != null) {
                            this.api.addPerm(group, perm, world);
                            continue block4;
                        }
                        this.api.addPerm(group, perm);
                        continue block4;
                    }
                    if (world != null) {
                        this.api.addPerm(group, perm, world, sec);
                        continue block4;
                    }
                    this.api.addPerm(group, perm, sec);
                    continue block4;
                }
                case REMOVE: {
                    if (world != null) {
                        this.api.removePerm(group, perm, world);
                        continue block4;
                    }
                    this.api.removePerm(group, perm);
                }
            }
        }
    }

    protected String[] get(Event e) {
        if (this.world == null) {
            return this.api.getPerm((String)this.group.getSingle(e));
        }
        return this.api.getPerm((String)this.group.getSingle(e), (World)this.world.getSingle(e));
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean d) {
        return "permissions of " + this.group.toString(e, d) + (this.world == null ? "" : " in world " + this.world.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprGroupPerms.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all] perm[ission][s] of group %string% [in [world] %-world%] [for %-timespan%]", "group %string%'s perm[ission][s] [in [world] %-world%] [for %-timespan%]"});
    }
}

