/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.misc.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Server Whitelist")
@Description(value={"Add/remove players from the server's whitelist. Get all the players in the server's whitelist."})
@Examples(value={"add arg-1 to whitelist", "remove arg-1 from whitelist", "reset server whitelist", "set {_wl::*} to server whitelist"})
@Since(value="2.3.0")
public class ExprPlayerWhitelist
extends SimpleExpression<OfflinePlayer> {
    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected OfflinePlayer[] get(Event event) {
        ArrayList wl = new ArrayList(Bukkit.getWhitelistedPlayers());
        return wl.toArray(new OfflinePlayer[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            ((OfflinePlayer)delta[0]).setWhitelisted(true);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            ((OfflinePlayer)delta[0]).setWhitelisted(false);
        } else if (mode == Changer.ChangeMode.RESET) {
            for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                player.setWhitelisted(false);
            }
        } else if (mode == Changer.ChangeMode.SET) {
            Bukkit.setWhitelist((boolean)((Boolean)delta[0]));
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public String toString(Event e, boolean b) {
        return "whitelist";
    }

    static {
        Skript.registerExpression(ExprPlayerWhitelist.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[server] whitelist"});
    }
}

