/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.misc.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Server Whitelisted")
@Description(value={"Check if the server is white listed or not"})
@Examples(value={"if server is whitelisted:", "if server is not whitelisted:"})
@Since(value="2.3.0")
public class CondServerWhitelist
extends Condition {
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setNegated(i == 1);
        return true;
    }

    public boolean check(Event event) {
        boolean check = Bukkit.hasWhitelist();
        return this.isNegated() != check;
    }

    public String toString(Event e, boolean b) {
        return "server whitelisted";
    }

    static {
        Skript.registerCondition(CondServerWhitelist.class, (String[])new String[]{"server is whitelisted", "server is(n'| no)t whitelisted"});
    }
}

