/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.misc.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Player Whitelisted")
@Description(value={"Check if an offline player is whitelisted"})
@Examples(value={"if arg-1 is whitelisted:", "if arg-1 is not whitelisted:"})
@Since(value="2.3.0")
public class CondPlayerWhitelist
extends Condition {
    private Expression<OfflinePlayer> player;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.setNegated(i == 1);
        return true;
    }

    public boolean check(Event event) {
        boolean check = ((OfflinePlayer)this.player.getSingle(event)).isWhitelisted();
        return this.isNegated() != check;
    }

    public String toString(Event e, boolean b) {
        return this.player.toString(e, b) + " whitelisted";
    }

    static {
        Skript.registerCondition(CondPlayerWhitelist.class, (String[])new String[]{"%offlineplayer% is whitelisted", "%offlineplayer% is(n'| no)t whitelisted"});
    }
}

