/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.utils.api;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import me.TechsCode.UltraPermissions.UltraPermissions;
import me.TechsCode.UltraPermissions.UltraPermissionsAPI;
import me.TechsCode.UltraPermissions.storage.objects.Group;
import me.TechsCode.UltraPermissions.storage.objects.Permission;
import me.TechsCode.UltraPermissions.storage.objects.User;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import tk.shanebee.skperm.utils.api.API;

public class UltraAPI
implements API {
    private UltraPermissionsAPI api = UltraPermissions.getAPI();

    @Override
    public void addPerm(OfflinePlayer player, String permission) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        if (user.getPermissions().has(permission)) {
            return;
        }
        user.newPermission(permission).create();
    }

    @Override
    public void addPerm(OfflinePlayer player, String permission, World world) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        if (user.getPermissions().worlds(true, new String[]{world.getName()}).has(permission)) {
            return;
        }
        user.newPermission(permission).setWorld(world.getName()).create();
    }

    @Override
    public void addPerm(OfflinePlayer player, String permission, World world, int seconds) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        if (user.getPermissions().worlds(true, new String[]{world.getName()}).has(permission)) {
            return;
        }
        Timestamp time = Timestamp.from(Instant.now().plusSeconds(seconds));
        user.newPermission(permission).setWorld(world.getName()).setExpiration(time.getTime()).create();
    }

    @Override
    public void addPerm(OfflinePlayer player, String permission, int seconds) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        if (user.getPermissions().has(permission)) {
            return;
        }
        Timestamp time = Timestamp.from(Instant.now().plusSeconds(seconds));
        user.newPermission(permission).setExpiration(time.getTime()).create();
    }

    @Override
    public void addPerm(String group, String permission) {
        Group groupT = this.api.getGroups().name(group);
        if (groupT.getPermissions().has(permission)) {
            return;
        }
        groupT.newPermission(permission).create();
    }

    @Override
    public void addPerm(String group, String permission, World world) {
        Group groupT = this.api.getGroups().name(group);
        if (groupT.getPermissions().worlds(true, new String[]{world.getName()}).has(permission)) {
            return;
        }
        groupT.newPermission(permission).setWorld(world.getName()).create();
    }

    @Override
    public void addPerm(String group, String permission, World world, int seconds) {
        Group groupT = this.api.getGroups().name(group);
        if (groupT.getPermissions().worlds(true, new String[]{world.getName()}).has(permission)) {
            return;
        }
        Timestamp time = Timestamp.from(Instant.now().plusSeconds(seconds));
        groupT.newPermission(permission).setWorld(world.getName()).setExpiration(time.getTime()).create();
    }

    @Override
    public void addPerm(String group, String permission, int seconds) {
        Group groupT = this.api.getGroups().name(group);
        if (groupT.getPermissions().has(permission)) {
            return;
        }
        Timestamp time = Timestamp.from(Instant.now().plusSeconds(seconds));
        groupT.newPermission(permission).setExpiration(time.getTime()).create();
    }

    @Override
    public void removePerm(OfflinePlayer player, String permission) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        for (Permission perm : user.getPermissions().get()) {
            if (!perm.getName().equalsIgnoreCase(permission)) continue;
            perm.remove();
        }
    }

    @Override
    public void removePerm(OfflinePlayer player, String permission, World world) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        for (Permission perm : user.getPermissions().worlds(true, new String[]{world.getName()}).get()) {
            if (!perm.getName().equalsIgnoreCase(permission)) continue;
            perm.remove();
        }
    }

    @Override
    public void removePerm(String group, String permission) {
        Group groupT = this.api.getGroups().name(group);
        for (Permission perm : groupT.getPermissions().get()) {
            if (!perm.getName().equalsIgnoreCase(permission)) continue;
            perm.remove();
        }
    }

    @Override
    public void removePerm(String group, String permission, World world) {
        Group groupT = this.api.getGroups().name(group);
        for (Permission perm : groupT.getPermissions().worlds(true, new String[]{world.getName()}).get()) {
            if (!perm.getName().equalsIgnoreCase(permission)) continue;
            perm.remove();
        }
    }

    @Override
    public String[] getPerm(OfflinePlayer player) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        ArrayList<String> list = new ArrayList<String>();
        for (Permission perm : user.getPermissions().get()) {
            list.add(perm.getName());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getPerm(OfflinePlayer player, World world) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        ArrayList<String> list = new ArrayList<String>();
        for (Permission perm : user.getPermissions().worlds(true, new String[]{world.getName()}).get()) {
            list.add(perm.getName());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getPerm(String group) {
        Group groupT = this.api.getGroups().name(group);
        ArrayList<String> list = new ArrayList<String>();
        for (Permission perm : groupT.getPermissions().get()) {
            list.add(perm.getName());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getPerm(String group, World world) {
        Group groupT = this.api.getGroups().name(group);
        ArrayList<String> list = new ArrayList<String>();
        for (Permission perm : groupT.getPermissions().worlds(true, new String[]{world.getName()}).get()) {
            list.add(perm.getName());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public void createGroup(String group) {
        if (this.api.getGroups().name(group) == null) {
            this.api.newGroup(group).create();
        }
    }

    @Override
    public void createGroup(String group, String[] parents) {
        if (this.api.getGroups().name(group) == null) {
            this.api.newGroup(group).create();
            Group groupT = this.api.getGroups().name(group);
            for (String par : parents) {
                Group parent = this.api.getGroups().name(par);
                groupT.addGroup(parent);
            }
            groupT.save();
        }
    }

    @Override
    public void removeGroup(String group) {
        this.api.getGroups().name(group).remove();
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        Group groupT = this.api.getGroups().name(group);
        if (groupT == null) {
            return;
        }
        user.addGroup(groupT);
        user.save();
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group, World world) {
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group, World world, int seconds) {
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group, int seconds) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        Group groupT = this.api.getGroups().name(group);
        Timestamp time = Timestamp.from(Instant.now().plusSeconds(seconds));
        user.addGroup(groupT, time.getTime());
        user.save();
    }

    @Override
    public void removePlayerFromGroup(OfflinePlayer player, String group) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        Group groupT = this.api.getGroups().name(group);
        if (groupT == null) {
            return;
        }
        user.removeGroup(groupT);
        user.save();
    }

    @Override
    public void removePlayerFromGroup(OfflinePlayer player, String group, World world) {
    }

    @Override
    public OfflinePlayer[] getPlayersInGroup(String group) {
        ArrayList<OfflinePlayer> list = new ArrayList<OfflinePlayer>();
        for (OfflinePlayer player : Bukkit.getServer().getOfflinePlayers()) {
            User user = this.api.getUsers().uuid(player.getUniqueId());
            if (user == null || user.getGroups().name(group) == null) continue;
            list.add(player);
        }
        return list.toArray(new OfflinePlayer[0]);
    }

    @Override
    public void setGroupWeight(String group, int weight) {
        Group groupT = this.api.getGroups().name(group);
        groupT.setPriority(weight);
        groupT.save();
    }

    @Override
    public void setGroupRank(String group, int rank) {
    }

    @Override
    public int getGroupWeight(String group) {
        Group groupT = this.api.getGroups().name(group);
        return groupT.getPriority();
    }

    @Override
    public int getGroupRank(String group) {
        return 0;
    }

    @Override
    public void setGroupPrefix(String group, String prefix) {
        Group groupT = this.api.getGroups().name(group);
        groupT.setPrefix(prefix);
        groupT.save();
    }

    @Override
    public void setGroupPrefix(String group, String prefix, World world) {
        Group groupT = this.api.getGroups().name(group);
        groupT.setPrefix(prefix);
        groupT.save();
    }

    @Override
    public String getGroupPrefix(String group) {
        return this.api.getGroups().name(group).getPrefix();
    }

    @Override
    public String getGroupPrefix(String group, World world) {
        return this.api.getGroups().name(group).getPrefix();
    }

    @Override
    public void setGroupSuffix(String group, String suffix) {
        Group groupT = this.api.getGroups().name(group);
        groupT.setSuffix(suffix);
        groupT.save();
    }

    @Override
    public void setGroupSuffix(String group, String suffix, World world) {
        Group groupT = this.api.getGroups().name(group);
        groupT.setSuffix(suffix);
        groupT.save();
    }

    @Override
    public String getGroupSuffix(String group) {
        return this.api.getGroups().name(group).getSuffix();
    }

    @Override
    public String getGroupSuffix(String group, World world) {
        return this.api.getGroups().name(group).getSuffix();
    }

    @Override
    public void setPlayerPrefix(OfflinePlayer player, String prefix) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        user.setPrefix(prefix);
        user.save();
    }

    @Override
    public void setPlayerPrefix(OfflinePlayer player, String prefix, World world) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        user.setPrefix(prefix);
        user.save();
    }

    @Override
    public String getPlayerPrefix(OfflinePlayer player) {
        return this.api.getUsers().uuid(player.getUniqueId()).getPrefix();
    }

    @Override
    public String getPlayerPrefix(OfflinePlayer player, World world) {
        return this.api.getUsers().uuid(player.getUniqueId()).getPrefix();
    }

    @Override
    public void setPlayerSuffix(OfflinePlayer player, String suffix) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        user.setSuffix(suffix);
        user.save();
    }

    @Override
    public void setPlayerSuffix(OfflinePlayer player, String suffix, World world) {
        User user = this.api.getUsers().uuid(player.getUniqueId());
        user.setSuffix(suffix);
        user.save();
    }

    @Override
    public String getPlayerSuffix(OfflinePlayer player) {
        return this.api.getUsers().uuid(player.getUniqueId()).getSuffix();
    }

    @Override
    public String getPlayerSuffix(OfflinePlayer player, World world) {
        return this.api.getUsers().uuid(player.getUniqueId()).getSuffix();
    }
}

