/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.permPlugins.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;
import tk.shanebee.skperm.utils.api.API;

@Name(value="Permission: Player Prefix/Suffix")
@Description(value={"Get/Set prefix/suffix of players. IF you have issues with it clashing with Skript's expression, make sure to add \"perm\" or \"permission\" to the front of your code[Requires a permission plugin, Currently supports PEX, LuckPerms and UltraPermissions]"})
@Examples(value={"set perm prefix of player to \"[MrBob]\"", "set {_pre} to prefix of player"})
@Since(value="2.2.0")
public class ExprPlayerPrefixSuffix
extends SimpleExpression<String> {
    private API api = SkPerm.getAPI();
    private Expression<OfflinePlayer> player;
    private Expression<World> world;
    private int parse;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.world = exprs[1];
        this.parse = parseResult.mark;
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    protected String[] get(Event e) {
        if (this.parse == 0) {
            if (this.world == null) {
                return (String[])CollectionUtils.array((Object[])new String[]{this.api.getPlayerPrefix((OfflinePlayer)this.player.getSingle(e))});
            }
            return (String[])CollectionUtils.array((Object[])new String[]{this.api.getPlayerPrefix((OfflinePlayer)this.player.getSingle(e), (World)this.world.getSingle(e))});
        }
        if (this.world == null) {
            return (String[])CollectionUtils.array((Object[])new String[]{this.api.getPlayerSuffix((OfflinePlayer)this.player.getSingle(e))});
        }
        return (String[])CollectionUtils.array((Object[])new String[]{this.api.getPlayerSuffix((OfflinePlayer)this.player.getSingle(e), (World)this.world.getSingle(e))});
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer player = (OfflinePlayer)this.player.getSingle(e);
        String value = (String)delta[0];
        switch (mode) {
            case SET: {
                if (this.parse == 0) {
                    if (this.world == null) {
                        this.api.setPlayerPrefix(player, value);
                        break;
                    }
                    this.api.setPlayerPrefix(player, value, (World)this.world.getSingle(e));
                    break;
                }
                if (this.world == null) {
                    this.api.setPlayerSuffix(player, value);
                    break;
                }
                this.api.setPlayerSuffix(player, value, (World)this.world.getSingle(e));
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean d) {
        return (this.parse == 0 ? "Prefix " : "Suffix ") + " of player " + this.player.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprPlayerPrefixSuffix.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [perm[ission]] (0\u00a6prefix|1\u00a6suffix) of %offlineplayer% [in [world] %-world%]", "%offlineplayer%'s [the] [perm[ission]] (0\u00a6prefix|1\u00a6suffix) [in [world] %-world%]"});
    }
}

