/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.permPlugins.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;
import tk.shanebee.skperm.utils.api.API;

@Name(value="Permission: Permissions of Player")
@Description(value={"Returns a list of all the player's permissions with an option to get the permissions for a specific world. You can also add/remove permissions to/from a player (Supports lists of permissions/strings) [Support for timed permissions does not seem to be working in PEX. May or may not work] [Requires a permission plugin, Currently supports PEX, LuckPerms and UltraPermissions]"})
@Examples(value={"set {_perms::*} to all permissions of player", "set {_perms::*} to all permissions of player in \"world\"", "send \"Perms in %world of player%: %all permissions of player in world of player%\"", "add \"essentials.chat\" to permissions of player", "add \"essentials.fly\" to permissions of player in world of player", "remove \"essentials.fly\" from permissions of player"})
@Since(value="2.0.0")
public class ExprPlayerPerms
extends SimpleExpression<String> {
    private API api = SkPerm.getAPI();
    private Expression<OfflinePlayer> player;
    private Expression<World> world;
    private Expression<Timespan> time;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.world = exprs[1];
        this.time = exprs[2];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String[] perms = delta == null ? null : (String[])Arrays.copyOf(delta, delta.length, String[].class);
        World world = this.world == null ? null : (World)this.world.getSingle(e);
        int sec = this.time == null ? 0 : (int)((Timespan)this.time.getSingle(e)).getTicks_i() / 20;
        OfflinePlayer player = (OfflinePlayer)this.player.getSingle(e);
        switch (mode) {
            case ADD: {
                if (perms == null) {
                    return;
                }
                for (String perm : perms) {
                    if (sec == 0) {
                        if (world != null) {
                            this.api.addPerm(player, perm, world);
                            continue;
                        }
                        this.api.addPerm(player, perm);
                        continue;
                    }
                    if (world != null) {
                        this.api.addPerm(player, perm, world, sec);
                        continue;
                    }
                    this.api.addPerm(player, perm, sec);
                }
                break;
            }
            case REMOVE: {
                if (perms == null) {
                    return;
                }
                for (String perm : perms) {
                    if (world != null) {
                        this.api.removePerm(player, perm, world);
                        continue;
                    }
                    this.api.removePerm(player, perm);
                }
                break;
            }
        }
    }

    protected String[] get(Event e) {
        if (this.world != null) {
            return this.api.getPerm((OfflinePlayer)this.player.getSingle(e), (World)this.world.getSingle(e));
        }
        return this.api.getPerm((OfflinePlayer)this.player.getSingle(e));
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean d) {
        return "permissions of " + this.player.toString(e, d) + (this.world == null ? "" : " in world " + this.world.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprPlayerPerms.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"perm[ission][s] of %offlineplayer% [in [world] %-world%] [for %-timespan%]", "%offlineplayer%'s perm[ission][s] [in [world] %-world%] [for %-timespan%]"});
    }
}

