/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.utils.api;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.LuckPermsApi;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.User;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import tk.shanebee.skperm.utils.api.API;

public class LuckAPI
implements API {
    private LuckPermsApi api = LuckPerms.getApi();

    @Override
    public void addPerm(OfflinePlayer player, String permission) {
        Node node = this.api.getNodeFactory().newBuilder(permission).build();
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        if (user != null) {
            user.setPermission(node);
            this.api.getUserManager().saveUser(user);
            Bukkit.getConsoleSender().sendMessage("Player Saved");
        }
    }

    @Override
    public void addPerm(OfflinePlayer player, String permission, World world) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).build();
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        if (user != null) {
            user.setPermission(node);
            this.api.getUserManager().saveUser(user);
        }
    }

    @Override
    public void addPerm(OfflinePlayer player, String permission, World world, int seconds) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).setExpiry((long)seconds, TimeUnit.SECONDS).build();
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        if (user != null) {
            user.setPermission(node);
            this.api.getUserManager().saveUser(user);
        }
    }

    @Override
    public void addPerm(OfflinePlayer player, String permission, int seconds) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setExpiry((long)seconds, TimeUnit.SECONDS).build();
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        if (user != null) {
            user.setPermission(node);
            this.api.getUserManager().saveUser(user);
        }
    }

    @Override
    public void addPerm(String group, String permission) {
        Node node = this.api.getNodeFactory().newBuilder(permission).build();
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            groupT.setPermission(node);
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public void addPerm(String group, String permission, World world) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).build();
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            groupT.setPermission(node);
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public void addPerm(String group, String permission, World world, int seconds) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).setExpiry((long)seconds, TimeUnit.SECONDS).build();
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            groupT.setPermission(node);
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public void addPerm(String group, String permission, int seconds) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setExpiry((long)seconds, TimeUnit.SECONDS).build();
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            groupT.setPermission(node);
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public void removePerm(OfflinePlayer player, String permission) {
        Node node = this.api.getNodeFactory().newBuilder(permission).build();
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        if (user != null) {
            user.unsetPermission(node);
            for (World worldB : Bukkit.getServer().getWorlds()) {
                node = this.api.getNodeFactory().newBuilder(permission).setWorld(worldB.getName()).build();
                user.unsetPermission(node);
            }
            this.api.getUserManager().saveUser(user);
        }
    }

    @Override
    public void removePerm(OfflinePlayer player, String permission, World world) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).build();
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        if (user != null) {
            user.unsetPermission(node);
            this.api.getUserManager().saveUser(user);
        }
    }

    @Override
    public void removePerm(String group, String permission) {
        Node node = this.api.getNodeFactory().newBuilder(permission).build();
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            groupT.unsetPermission(node);
            for (World world : Bukkit.getServer().getWorlds()) {
                node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).build();
                groupT.unsetPermission(node);
            }
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public void removePerm(String group, String permission, World world) {
        Node node = this.api.getNodeFactory().newBuilder(permission).setWorld(world.getName()).build();
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            groupT.unsetPermission(node);
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public String[] getPerm(OfflinePlayer player) {
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        ArrayList<String> perms = new ArrayList<String>();
        for (Node perm : user.getPermissions()) {
            if (perm.getPermission().startsWith("group.")) continue;
            perms.add(perm.getPermission());
        }
        return perms.toArray(new String[0]);
    }

    @Override
    public String[] getPerm(OfflinePlayer player, World world) {
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        ArrayList<String> perms = new ArrayList<String>();
        for (Node perm : user.getPermissions()) {
            if (perm.getPermission().startsWith("group.") || !perm.getWorld().isPresent() || !perm.getWorld().toString().contains("[" + world.getName() + "]")) continue;
            perms.add(perm.getPermission());
        }
        return perms.toArray(new String[0]);
    }

    @Override
    public String[] getPerm(String group) {
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return null;
        }
        ArrayList<String> perms = new ArrayList<String>();
        for (Node perm : groupT.getPermissions()) {
            if (perm.getPermission().startsWith("prefix.") || perm.getPermission().startsWith("weight.") || perm.getPermission().startsWith("suffix.")) continue;
            perms.add(perm.getPermission());
        }
        return perms.toArray(new String[0]);
    }

    @Override
    public String[] getPerm(String group, World world) {
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return null;
        }
        ArrayList<String> perms = new ArrayList<String>();
        for (Node perm : groupT.getPermissions()) {
            if (perm.getPermission().startsWith("prefix.") || perm.getPermission().startsWith("weight.") || perm.getPermission().startsWith("suffix.") || !perm.getWorld().toString().contains("[" + world.getName() + "]")) continue;
            perms.add(perm.getPermission());
        }
        return perms.toArray(new String[0]);
    }

    @Override
    public void createGroup(String group) {
        this.api.getGroupManager().createAndLoadGroup(group);
    }

    @Override
    public void createGroup(String group, String[] parents) {
        this.api.getGroupManager().createAndLoadGroup(group);
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return;
        }
        for (String parent : parents) {
            Node node = this.api.getNodeFactory().makeGroupNode(parent).build();
            groupT.setPermission(node);
            this.api.getGroupManager().saveGroup(groupT);
        }
    }

    @Override
    public void removeGroup(String group) {
        Group groupT = this.api.getGroup(group);
        if (groupT != null) {
            this.api.getGroupManager().deleteGroup(groupT);
        }
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group) {
        if (!this.api.getGroupManager().isLoaded(group)) {
            return;
        }
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        Node node = this.api.getNodeFactory().makeGroupNode(group).build();
        user.setPermission(node);
        this.api.getUserManager().saveUser(user);
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group, World world) {
        if (!this.api.getGroupManager().isLoaded(group)) {
            return;
        }
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        Node node = this.api.getNodeFactory().makeGroupNode(group).setWorld(world.getName()).build();
        user.setPermission(node);
        this.api.getUserManager().saveUser(user);
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group, World world, int seconds) {
        if (!this.api.getGroupManager().isLoaded(group)) {
            return;
        }
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        Node node = this.api.getNodeFactory().makeGroupNode(group).setWorld(world.getName()).setExpiry((long)seconds, TimeUnit.SECONDS).build();
        user.setPermission(node);
        this.api.getUserManager().saveUser(user);
    }

    @Override
    public void addPlayerToGroup(OfflinePlayer player, String group, int seconds) {
        if (!this.api.getGroupManager().isLoaded(group)) {
            return;
        }
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        Node node = this.api.getNodeFactory().makeGroupNode(group).setExpiry((long)seconds, TimeUnit.SECONDS).build();
        user.setPermission(node);
        this.api.getUserManager().saveUser(user);
    }

    @Override
    public void removePlayerFromGroup(OfflinePlayer player, String group) {
        if (!this.api.getGroupManager().isLoaded(group)) {
            return;
        }
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        Node node = this.api.getNodeFactory().makeGroupNode(group).build();
        user.unsetPermission(node);
        for (World worldB : Bukkit.getServer().getWorlds()) {
            node = this.api.getNodeFactory().makeGroupNode(group).setWorld(worldB.getName()).build();
            user.unsetPermission(node);
        }
        this.api.getUserManager().saveUser(user);
    }

    @Override
    public void removePlayerFromGroup(OfflinePlayer player, String group, World world) {
        if (!this.api.getGroupManager().isLoaded(group)) {
            return;
        }
        User user = (User)this.api.getUserManager().loadUser(player.getUniqueId()).join();
        Node node = this.api.getNodeFactory().makeGroupNode(group).setWorld(world.getName()).build();
        user.unsetPermission(node);
        this.api.getUserManager().saveUser(user);
    }

    @Override
    public OfflinePlayer[] getPlayersInGroup(String group) {
        ArrayList<OfflinePlayer> list = new ArrayList<OfflinePlayer>();
        for (OfflinePlayer player : Bukkit.getServer().getOfflinePlayers()) {
            this.api.getUserManager().loadUser(player.getUniqueId()).join();
            if (!this.api.getUserManager().isLoaded(player.getUniqueId())) continue;
            for (Node node : this.api.getUser(player.getUniqueId()).getAllNodes()) {
                if (!node.getPermission().contains("group." + group)) continue;
                list.add(player);
            }
        }
        return list.toArray(new OfflinePlayer[0]);
    }

    @Override
    public void setGroupWeight(String group, int weight) {
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return;
        }
        for (Node perm : groupT.getPermissions()) {
            if (!perm.getPermission().startsWith("weight.")) continue;
            groupT.unsetPermission(perm);
        }
        Node newWeight = this.api.getNodeFactory().newBuilder("weight." + weight).build();
        groupT.setPermission(newWeight);
        this.api.getGroupManager().saveGroup(groupT);
    }

    @Override
    public void setGroupRank(String group, int rank) {
    }

    @Override
    public int getGroupWeight(String group) {
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return 0;
        }
        if (groupT.getWeight().isPresent()) {
            return groupT.getWeight().getAsInt();
        }
        return 0;
    }

    @Override
    public int getGroupRank(String group) {
        return 0;
    }

    @Override
    public void setGroupPrefix(String group, String prefix) {
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return;
        }
        for (Node nodeD : this.api.getGroup(group).getPermissions()) {
            if (!nodeD.getPermission().startsWith("prefix.")) continue;
            groupT.unsetPermission(nodeD);
        }
        Node node = this.api.getNodeFactory().makePrefixNode(0, prefix).build();
        groupT.setPermission(node);
        this.api.getGroupManager().saveGroup(groupT);
    }

    @Override
    public void setGroupPrefix(String group, String prefix, World world) {
        Group groupT = this.api.getGroup(group);
        Node node = this.api.getNodeFactory().makePrefixNode(0, prefix).setWorld(world.getName()).build();
        if (groupT == null) {
            return;
        }
        for (Node nodeD : this.api.getGroup(group).getPermissions()) {
            if (!nodeD.getPermission().startsWith("prefix.") || !nodeD.getWorld().toString().startsWith("Optional[" + world.getName() + "]")) continue;
            groupT.unsetPermission(nodeD);
        }
        groupT.setPermission(node);
        this.api.getGroupManager().saveGroup(groupT);
    }

    @Override
    public String getGroupPrefix(String group) {
        Group groupT = this.api.getGroupManager().getGroup(group);
        String prefix = null;
        if (groupT == null) {
            return null;
        }
        for (Node node : groupT.getPermissions()) {
            if (!node.getPermission().startsWith("prefix.")) continue;
            prefix = (String)node.getPrefix().getValue();
        }
        return prefix;
    }

    @Override
    public String getGroupPrefix(String group, World world) {
        Group groupT = this.api.getGroupManager().getGroup(group);
        String prefix = null;
        if (groupT == null) {
            return null;
        }
        for (Node node : groupT.getPermissions()) {
            if (!node.getPermission().startsWith("prefix.") || !node.getWorld().toString().startsWith("Optional[" + world.getName() + "]")) continue;
            prefix = (String)node.getPrefix().getValue();
        }
        return prefix;
    }

    @Override
    public void setGroupSuffix(String group, String suffix) {
        Group groupT = this.api.getGroup(group);
        if (groupT == null) {
            return;
        }
        for (Node nodeD : this.api.getGroup(group).getPermissions()) {
            if (!nodeD.getPermission().startsWith("suffix.")) continue;
            groupT.unsetPermission(nodeD);
        }
        Node node = this.api.getNodeFactory().makeSuffixNode(0, suffix).build();
        groupT.setPermission(node);
        this.api.getGroupManager().saveGroup(groupT);
    }

    @Override
    public void setGroupSuffix(String group, String suffix, World world) {
        Group groupT = this.api.getGroup(group);
        Node node = this.api.getNodeFactory().makeSuffixNode(0, suffix).setWorld(world.getName()).build();
        if (groupT == null) {
            return;
        }
        for (Node nodeD : this.api.getGroup(group).getPermissions()) {
            if (!nodeD.getPermission().startsWith("suffix.") || !nodeD.getWorld().toString().startsWith("Optional[" + world.getName() + "]")) continue;
            groupT.unsetPermission(nodeD);
        }
        groupT.setPermission(node);
        this.api.getGroupManager().saveGroup(groupT);
    }

    @Override
    public String getGroupSuffix(String group) {
        Group groupT = this.api.getGroupManager().getGroup(group);
        String suffix = null;
        if (groupT == null) {
            return null;
        }
        for (Node node : groupT.getPermissions()) {
            if (!node.getPermission().startsWith("suffix.")) continue;
            suffix = (String)node.getSuffix().getValue();
        }
        return suffix;
    }

    @Override
    public String getGroupSuffix(String group, World world) {
        Group groupT = this.api.getGroupManager().getGroup(group);
        String suffix = null;
        if (groupT == null) {
            return null;
        }
        for (Node node : groupT.getPermissions()) {
            if (!node.getPermission().startsWith("suffix.") || !node.getWorld().toString().startsWith("Optional[" + world.getName() + "]")) continue;
            suffix = (String)node.getSuffix().getValue();
        }
        return suffix;
    }
}

