/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.vault.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;

@Name(value="Permission: Group's Players")
@Description(value={"Add or remove player's to/from groups. Vault does not seem to allow getting players of a group. Worlds are only supported if your permission plugin supports them."})
@Examples(value={"add player to group \"Admin\"", "remove player from group \"Moderator\"", "add player to group \"member\" in \"world\"", "remove player from group \"default\" in world \"world_nether\""})
@RequiredPlugins(value={"Vault"})
@Since(value="1.0.0")
public class ExprPlayerGroup
extends SimpleExpression<OfflinePlayer> {
    private Permission manager = SkPerm.perms;
    private Expression<World> world;
    private Expression<String> group;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = exprs[0];
        this.world = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Player.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer[] players = (OfflinePlayer[])delta;
        String w = this.world == null ? null : ((World)this.world.getSingle(e)).getName();
        block4: for (OfflinePlayer player : players) {
            switch (mode) {
                case ADD: {
                    this.manager.playerAddGroup(w, player, (String)this.group.getSingle(e));
                    continue block4;
                }
                case REMOVE: {
                    this.manager.playerRemoveGroup(w, player, (String)this.group.getSingle(e));
                }
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public String toString(Event event, boolean debug) {
        return "group " + this.group.toString(event, debug);
    }

    protected Player[] get(Event event) {
        return null;
    }

    static {
        Skript.registerExpression(ExprPlayerGroup.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"group %string% [in [world] %-world%]"});
    }
}

