/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.permPlugins.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;
import tk.shanebee.skperm.utils.api.API;

@Name(value="Permission: Group Members")
@Description(value={"Get all the users in a group. Also supports adding and removing players to/from groups. Currently only PEX is supported"})
@Examples(value={"add player to group \"owner\"", "remove player from group \"moderator\""})
@Since(value="2.0.0")
public class ExprPlayerGroup
extends SimpleExpression<OfflinePlayer> {
    private API api = SkPerm.getAPI();
    private Expression<World> world;
    private Expression<String> group;
    private Expression<Timespan> time;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = exprs[0];
        this.world = exprs[1];
        this.time = exprs[2];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer[] players = (OfflinePlayer[])delta;
        World world = this.world == null ? null : (World)this.world.getSingle(e);
        String group = (String)this.group.getSingle(e);
        int sec = this.time == null ? 0 : (int)((Timespan)this.time.getSingle(e)).getTicks_i() / 20;
        block4: for (OfflinePlayer player : players) {
            switch (mode) {
                case ADD: {
                    if (sec != 0) {
                        if (world != null) {
                            this.api.addPlayerToGroup(player, group, world, sec);
                            continue block4;
                        }
                        this.api.addPlayerToGroup(player, group, sec);
                        continue block4;
                    }
                    if (world != null) {
                        this.api.addPlayerToGroup(player, group, world);
                        continue block4;
                    }
                    this.api.addPlayerToGroup(player, group);
                    continue block4;
                }
                case REMOVE: {
                    if (sec != 0) {
                        return;
                    }
                    if (world != null) {
                        this.api.removePlayerFromGroup(player, group, world);
                        continue block4;
                    }
                    this.api.removePlayerFromGroup(player, group);
                }
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public String toString(Event e, boolean d) {
        return "group " + this.group.toString(e, d);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        return this.api.getPlayersInGroup((String)this.group.getSingle(e));
    }

    static {
        Skript.registerExpression(ExprPlayerGroup.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[members of] group %string% [in [world] %-world%] [for %-timespan%])"});
    }
}

