/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.permPlugins.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;
import tk.shanebee.skperm.utils.api.API;

@Name(value="Permission: Create/Delete Group")
@Description(value={"Create a new permission group or remove one. Optional parents can be added. Currently supports PEX"})
@Examples(value={"create new group \"default\"", "create new group \"moderator\" with parent \"default\"", "create new group \"admin\" with parents \"moderator\" and \"default\"", "remove group \"moderator\""})
@Since(value="2.0.0")
public class EffCreateGroup
extends Effect {
    private API api = SkPerm.getAPI();
    private Expression<String> group;
    private int parse;
    private Expression<String> parents;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = expr[0];
        this.parse = parseResult.mark;
        this.parents = expr[1];
        return true;
    }

    protected void execute(Event e) {
        if (this.parse == 0) {
            if (this.parents != null) {
                this.api.createGroup((String)this.group.getSingle(e), (String[])this.parents.getArray(e));
            } else {
                this.api.createGroup((String)this.group.getSingle(e));
            }
        } else {
            this.api.removeGroup((String)this.group.getSingle(e));
        }
    }

    public String toString(Event e, boolean d) {
        return (this.parse == 0 ? "create new" : " delete") + " group " + this.group.toString(e, d) + (this.parents != null ? " with parents " + this.parents.toString(e, d) : "");
    }

    static {
        Skript.registerEffect(EffCreateGroup.class, (String[])new String[]{"(0\u00a6create [new]|1\u00a6(delete|remove)) group %string% [with parent[s] %-strings%]"});
    }
}

