/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.vault.elements.Expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachmentInfo;
import tk.shanebee.skperm.SkPerm;

@Name(value="Permission: Player's Permissions")
@Description(value={"Add or remove permissions of a player. Worlds are only supported if your permission plugin supports them.Getting permissions for offline players is not supported."})
@Examples(value={"add \"essentials.home\" to permission of player", "add \"essentials.teleport\" to permission of player in world \"world\"", "remove \"essentials.tp\" from permission of player"})
@RequiredPlugins(value={"Vault"})
@Since(value="1.0.0")
public class ExprPlayerPerm
extends SimpleExpression<String> {
    private Permission manager = SkPerm.perms;
    private Expression<OfflinePlayer> players;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.world = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String[] perms = delta != null ? (String[])delta : null;
        String w = this.world == null ? null : ((World)this.world.getSingle(e)).getName();
        block4: for (OfflinePlayer p : (OfflinePlayer[])this.players.getArray(e)) {
            switch (mode) {
                case ADD: {
                    if (perms == null) {
                        return;
                    }
                    for (String perm : perms) {
                        this.manager.playerAdd(w, p, perm);
                    }
                    continue block4;
                }
                case REMOVE: {
                    if (perms == null) {
                        return;
                    }
                    for (String perm : perms) {
                        this.manager.playerRemove(w, p, perm);
                    }
                    continue block4;
                }
            }
        }
    }

    @Nullable
    protected String[] get(Event e) {
        HashSet<String> permissions = new HashSet<String>();
        for (OfflinePlayer player : (OfflinePlayer[])this.players.getArray(e)) {
            if (player.isOnline()) {
                Player p = (Player)player;
                for (PermissionAttachmentInfo permission : p.getEffectivePermissions()) {
                    permissions.add(permission.getPermission());
                }
                continue;
            }
            permissions.add(ChatColor.RED + player.getName() + " is not online");
        }
        return permissions.toArray(new String[permissions.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean debug) {
        return "permissions of " + this.players.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprPlayerPerm.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"perm[ission][s] of %offlineplayers% [in [world]%-world%]", "%offlineplayers%'s perm[ission][s] [in [world]%-world%]"});
    }
}

