/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.pex.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import tk.shanebee.skperm.SkPerm;

@Name(value="PEX: Permissions of Player")
@Description(value={"Returns a list of all the player's permissions with an option to get the permissions for a specific world. You can also add/remove permissions to/from a player."})
@Examples(value={"set {_perms::*} to all permissions of player", "set {_perms::*} to all permissions of player in \"world\"", "send \"Perms in %world of player%: %all permissions of player in world of player%\"", "add \"essentials.chat\" to permissions of player", "add \"essentials.fly\" to permissions of player in world of player", "remove \"essentials.fly\" from permissions of player"})
@RequiredPlugins(value={"PermissionsEX", "Vault"})
@Since(value="1.1.0")
public class ExprPermsOfPlayer
extends SimpleExpression<String> {
    private Permission manager = SkPerm.perms;
    private Expression<OfflinePlayer> player;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.world = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String[] perms = delta != null ? (String[])delta : null;
        String w = this.world == null ? null : ((World)this.world.getSingle(e)).getName();
        switch (mode) {
            case ADD: {
                if (perms == null) {
                    return;
                }
                for (String perm : perms) {
                    this.manager.playerAdd(w, (OfflinePlayer)this.player.getSingle(e), perm);
                }
                break;
            }
            case REMOVE: {
                if (perms == null) {
                    return;
                }
                for (String perm : perms) {
                    this.manager.playerRemove(w, (OfflinePlayer)this.player.getSingle(e), perm);
                }
                break;
            }
        }
    }

    protected String[] get(Event e) {
        String world = this.world == null ? null : ((World)this.world.getSingle(e)).getName();
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(((OfflinePlayer)this.player.getSingle(e)).getUniqueId());
        return user.getPermissions(world).toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean d) {
        return "permissions of " + this.player.toString(e, d) + (this.world == null ? "" : " in world " + this.world.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprPermsOfPlayer.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"perm[ission][s] of %offlineplayer% [in [world] %-world%]", "%offlineplayer%'s perm[ission][s] [in [world] %-world%]"});
    }
}

