/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.pex.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import tk.shanebee.skperm.SkPerm;

@Name(value="PEX: Permissions of Group")
@Description(value={"Returns a list of all the group's permissions with an option to get the permissions for a specific world. You can also add/remove permissions to/group a group"})
@Examples(value={"set {_perms::*} to all permissions of group \"mod\"", "set {_perms::*} to all permissions of group \"builder\" in world \"world\"", "send \"Perms in %world of player%: %all permissions of group \"\"admin\"\" in world of player%\"", "add \"essentials.fly\" to permissions of group \"builder\" in world \"world\"", "remove \"essentials.fly\" from permissions of group \"mod\""})
@RequiredPlugins(value={"Vault", "PermissionsEX"})
@Since(value="1.1.0")
public class ExprPermsOfGroup
extends SimpleExpression<String> {
    private Permission manager = SkPerm.perms;
    private Expression<String> group;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = exprs[0];
        this.world = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String[] perms = (String[])delta;
        String w = this.world == null ? null : ((World)this.world.getSingle(e)).getName();
        block4: for (String perm : perms) {
            switch (mode) {
                case ADD: {
                    this.manager.groupAdd(w, (String)this.group.getSingle(e), perm);
                    continue block4;
                }
                case REMOVE: {
                    this.manager.groupRemove(w, (String)this.group.getSingle(e), perm);
                }
            }
        }
    }

    protected String[] get(Event e) {
        String world = this.world == null ? null : ((World)this.world.getSingle(e)).getName();
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup((String)this.group.getSingle(e));
        return group.getPermissions(world).toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean d) {
        return "permissions of " + this.group.toString(e, d) + (this.world == null ? "" : " in world " + this.world.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprPermsOfGroup.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"perm[ission][s] of group %string% [in [world] %-world%]", "group %string%'s perm[ission][s] [in [world] %-world%]"});
    }
}

