/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.pex.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="PEX: Group Weight")
@Description(value={"Set the weight of a group."})
@Examples(value={"set weight of group \"owner\" to 1", "set weight of group \"admin\" to 100", "reset weight of group \"default\"", "set {_weight} to weight of group \"admin\""})
@RequiredPlugins(value={"Vault", "PermissionsEX"})
@Since(value="1.1.0")
public class ExprGroupWeight
extends SimpleExpression<Number> {
    private Expression<String> group;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    protected Number[] get(Event e) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup((String)this.group.getSingle(e));
        return (Number[])CollectionUtils.array((Object[])new Integer[]{group.getWeight()});
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup((String)this.group.getSingle(e));
        Number weight = (Number)delta[0];
        switch (mode) {
            case SET: {
                group.setWeight(weight.intValue());
                break;
            }
            case REMOVE: 
            case RESET: {
                group.setWeight(0);
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event e, boolean d) {
        return "weight of group " + this.group.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprGroupWeight.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"weight of group %string%", "group %string%'s weight"});
    }
}

