/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.pex.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.LinkedList;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="PEX: Create Group")
@Description(value={"Create a new PEX group. Optional parents can be added."})
@Examples(value={"pex create new group \"default\"", "pex create new group \"moderator\" with parent \"default\"", "pex remove group \"moderator\""})
@RequiredPlugins(value={"PermissionsEX", "Vault"})
@Since(value="1.1.0")
public class EffCreateGroup
extends Effect {
    private Expression<String> group;
    private int parse;
    private Expression<String> parents;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = expr[0];
        this.parse = parseResult.mark;
        this.parents = expr[1];
        return true;
    }

    protected void execute(Event e) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup((String)this.group.getSingle(e));
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        if (this.parse == 0) {
            if (this.parents != null) {
                for (String parent : (String[])this.parents.getAll(e)) {
                    groups.add(PermissionsEx.getPermissionManager().getGroup(parent));
                }
                group.setParents(groups, null);
            }
            group.save();
        } else {
            group.remove();
        }
    }

    public String toString(Event e, boolean d) {
        return "pex " + (this.parse == 0 ? "create new " : " delete") + "group " + this.group.toString(e, d) + (this.parents != null ? "with parents " + this.parents.toString(e, d) : "");
    }

    static {
        Skript.registerEffect(EffCreateGroup.class, (String[])new String[]{"[pex] (0\u00a6create [new]|1\u00a6(delete|remove)) group %string% [with parent[s] %-strings%]"});
    }
}

