/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.elements.Expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;

@Name(value="Permission: Group's Permissions")
@Description(value={"Add or remove permissions to/from a group. Worlds are only supported if your permission plugin supports them."})
@Examples(value={"add \"essentials.chat\" to permissions of group \"members\"", "add \"essentials.home\" to permissions of group \"knight\" in world \"world\"", "remove \"essentials.gamemode\" from permissions of group \"moderator\""})
@Since(value="1.0.0")
public class ExprGroupPerm
extends SimpleExpression<String> {
    private Permission manager = SkPerm.perms;
    private Expression<String> group;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.group = exprs[0];
        this.world = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String[] perms;
        block4: for (String perm : perms = (String[])delta) {
            switch (mode) {
                case ADD: {
                    if (this.world != null) {
                        this.manager.groupAdd(((World)this.world.getSingle(e)).getName(), (String)this.group.getSingle(e), perm);
                        continue block4;
                    }
                    this.manager.groupAdd((String)null, (String)this.group.getSingle(e), perm);
                    continue block4;
                }
                case REMOVE: {
                    if (this.world != null) {
                        this.manager.groupRemove(((World)this.world.getSingle(e)).getName(), (String)this.group.getSingle(e), perm);
                        continue block4;
                    }
                    this.manager.groupRemove((String)null, (String)this.group.getSingle(e), perm);
                }
            }
        }
    }

    protected String[] get(Event event) {
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean debug) {
        return "permission of group " + this.group.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprGroupPerm.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"perm[ission][s] of group %string% [in [world]%-world%]", "group %string%'s perm[ission][s] [in [world]%-world%]"});
    }
}

