/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skperm.elements.Conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.skperm.SkPerm;

@Name(value="Permission: Player in Group")
@Description(value={"Check if a player belongs to a group. Worlds are only supported if your permission plugin supports them."})
@Examples(value={"if player is in group \"moderator\":", "if player is a member of group \"admin\":", "if player is in group \"default\" in world \"world_nether\":"})
@Since(value="1.0.0")
public class CondPlayerinGroup
extends Condition {
    private Permission manager = SkPerm.perms;
    private Expression<OfflinePlayer> player;
    private Expression<String> group;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.group = exprs[1];
        this.world = exprs[2];
        return true;
    }

    public boolean check(Event e) {
        if (this.world != null) {
            return this.manager.playerInGroup(((World)this.world.getSingle(e)).getName(), (OfflinePlayer)this.player.getSingle(e), this.group.toString());
        }
        return this.manager.playerInGroup(null, (OfflinePlayer)this.player.getSingle(e), this.group.toString());
    }

    public String toString(Event e, boolean debug) {
        return "player " + this.player.toString(e, debug) + " is in group " + this.group.toString(e, debug) + (this.world != null ? " in world " + this.world.toString(e, debug) : "");
    }

    static {
        PropertyCondition.register(CondPlayerinGroup.class, (String)"(in|[a] member of) group %string% [in [world]%-world%]", (String)"offlineplayers");
    }
}

