/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elementsNBT.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.nms.NBTApi;

@Name(value="NBT - Tag")
@Description(value={"Returns the value of the specified tag of the specified NBT. Also supports getting nested tags (version 2.9.1+). (Currently only supports get. Set may be available in the future)"})
@Examples(value={"set {_tag} to tag \"Invulnerable\" of targeted entity's nbt", "send \"Tag: %tag \"\"CustomName\"\" of nbt of target entity%\" to player", "set {_tag} to \"Enchantments\" tag of nbt of player's tool", "set {_tag} to \"BlockEntityTag.Items\" tag of nbt of target block"})
@Since(value="1.0.0")
public class ExprTagOfNBT
extends SimpleExpression<String> {
    private Expression<String> a;
    private Expression<String> b;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.a = expressions[0];
        this.b = expressions[1];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        NBTApi api = NBeeT.getNBTApi();
        String t = (String)this.a.getSingle(e);
        String n = (String)this.b.getSingle(e);
        if (t.contains(".")) {
            return this.getFromList(t, n);
        }
        return api.getNBTTag(t, n);
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "Tag \"" + this.a.toString(e, d) + "\" of NBT " + this.b.toString(e, d);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    private String[] getFromList(String tag, String nbt) {
        NBTApi api = NBeeT.getNBTApi();
        String[] split = tag.split("\\.");
        String nbtNew = nbt;
        for (String s : split) {
            nbtNew = api.getNBTTag(s, nbtNew)[0];
        }
        return new String[]{nbtNew};
    }

    static {
        Skript.registerExpression(ExprTagOfNBT.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"tag %string% of %string%", "%string% tag of %string%"});
    }
}

