/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import tk.shanebee.nbt.config.BoundConfig;
import tk.shanebee.nbt.elements.objects.Bound;
import tk.shanebee.nbt.elements.objects.OldBound;
import tk.shanebee.nbt.listener.BoundBorderListener;
import tk.shanebee.nbt.nms.NBTApi;

public class NBeeT
extends JavaPlugin {
    private static NBeeT instance;
    private static NBTApi nbtApi;
    private PluginDescriptionFile desc = this.getDescription();
    private List<OldBound> bounds = new ArrayList<OldBound>();
    private BoundConfig boundConfig;

    public void onEnable() {
        instance = this;
        if (Bukkit.getPluginManager().getPlugin("Skript") != null && Skript.isAcceptRegistrations()) {
            long start = System.currentTimeMillis();
            this.boundConfig = new BoundConfig(this);
            int boundSize = this.boundConfig.getBounds().size();
            if (boundSize > 0) {
                this.sendColConsole("Loaded &b" + boundSize + "&7 bounds in " + (System.currentTimeMillis() - start) + " milliseconds.");
            }
            String nms = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            SkriptAddon addon = Skript.registerAddon((JavaPlugin)this);
            try {
                nbtApi = (NBTApi)Class.forName(NBeeT.class.getPackage().getName() + ".nms.NBT_" + nms).newInstance();
                this.sendColConsole("&bCompatible NMS version: " + nms);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.sendColConsole("&cSk-NBeeT is not supported on this version [" + ChatColor.AQUA + nms + ChatColor.RED + "] and will now be disabled");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            try {
                addon.loadClasses("tk.shanebee.nbt", new String[]{"elements"});
            }
            catch (IOException e) {
                e.printStackTrace();
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.sendColConsole("&aSuccessfully enabled v" + this.desc.getVersion());
            if (this.desc.getVersion().contains("Beta")) {
                this.sendColConsole("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub");
                this.sendColConsole("&ehttps://github.com/ShaneBeee/Sk-NBeeT/issues");
            }
        } else {
            this.sendColConsole("&cDependency Skript was not found, plugin disabling");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new BoundBorderListener(this), (Plugin)this);
    }

    public void onDisable() {
    }

    public static NBeeT getInstance() {
        return instance;
    }

    public static NBTApi getNBTApi() {
        return nbtApi;
    }

    public List<OldBound> getBounds() {
        return this.bounds;
    }

    public BoundConfig getBoundConfig() {
        return this.boundConfig;
    }

    public void sendColConsole(String message) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&bSk-NBeeT&7] " + message)));
    }

    static {
        ConfigurationSerialization.registerClass(Bound.class, (String)"Bound");
    }
}

