/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.structureblocklib.bukkit.core.business.service;

import com.github.shynixn.structureblocklib.bukkit.api.business.proxy.StructureBlock;
import com.github.shynixn.structureblocklib.bukkit.api.business.service.StructureBlockService;
import com.github.shynixn.structureblocklib.bukkit.core.VersionSupport;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class StructureBlockServiceImpl
implements StructureBlockService {
    private final VersionSupport versionSupport = VersionSupport.getServerVersion();

    @Override
    public <S extends StructureBlock> S getOrCreateStructureBlockAt(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        if (location.getBlock().getType() != Material.STRUCTURE_BLOCK) {
            location.getBlock().setType(Material.STRUCTURE_BLOCK);
        }
        try {
            Constructor<?> constructor = Class.forName("com.github.shynixn.structureblocklib.bukkit.core.nms.VERSION.CraftStructureBlock".replace("VERSION", this.versionSupport.getVersionText())).getDeclaredConstructor(Block.class);
            return (S)((StructureBlock)constructor.newInstance(location.getBlock()));
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to create structureBlock. Is your server version support?", ex);
            throw new RuntimeException(ex);
        }
    }
}

