/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.elements.objects.Bound;
import tk.shanebee.nbt.elements.objects.OldBound;

@Name(value="Bound - Convert")
@Description(value={"Convert a bound from the old format to the new format. ", "See the Sk-NBeeT wiki for conversion instructions: https://github.com/ShaneBeee/Sk-NBeeT/wiki/Bound-Conversion. ", "This will be removed in the future after enough time has passed to convert old bounds."})
@Examples(value={"convert old bound {bound} to new bound with id \"new.bound\""})
public class EffBoundConvert
extends Effect {
    private Expression<OldBound> oldBound;
    private Expression<String> id;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.oldBound = exprs[0];
        this.id = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        if (this.oldBound.getSingle(event) == null || this.id.getSingle(event) == null) {
            Skript.error((String)"Bound or ID = null:");
            Skript.error((String)(" " + this.toString(event, true)));
            return;
        }
        OldBound oldBound = (OldBound)this.oldBound.getSingle(event);
        String id = (String)this.id.getSingle(event);
        Location less = oldBound.getLesserCorner();
        Location great = oldBound.getGreaterCorner();
        Bound bound = new Bound(less, great, id);
        NBeeT.getInstance().getBoundConfig().saveBound(bound);
    }

    public String toString(Event e, boolean d) {
        return "Convert old bound " + this.oldBound.toString(e, d) + " to new bound with id " + this.id.toString(e, d);
    }

    static {
        Skript.registerEffect(EffBoundConvert.class, (String[])new String[]{"convert [old] bound %oldbound% to [a] [new] bound with id %string%"});
    }
}

