/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.nms.NBTApi;

@Name(value="Entity NoClip")
@Description(value={"Set or get the noClip status of an entity (This will not work on players)"})
@Examples(value={"spawn a zombie at player", "set not clip state of last spawned zombie to true", "set {_var} to no clip state of last spawned sheep", "loop all entities in radius 5 around player:", "\tset no clip state of loop-entity to true", "\tpush loop-entity up with speed 5"})
@Since(value="1.2.4")
public class ExprNoClip
extends SimpleExpression<Boolean> {
    private Expression<Entity> entities;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.entities = exprs[0];
        return true;
    }

    public boolean isSingle() {
        return this.entities.isSingle();
    }

    protected Boolean[] get(Event e) {
        NBTApi api = NBeeT.getNBTApi();
        Entity[] ents = (Entity[])this.entities.getAll(e);
        if (ents.length == 0) {
            return null;
        }
        Boolean[] noClipStates = new Boolean[ents.length];
        int i = 0;
        for (Entity ent : ents) {
            if (ent == null) continue;
            noClipStates[i] = api.getEntityNoClip(ent);
            ++i;
        }
        return noClipStates;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        NBTApi api = NBeeT.getNBTApi();
        Entity[] ents = (Entity[])this.entities.getAll(e);
        if (ents.length == 0) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            Boolean newValue = (Boolean)delta[0];
            for (Entity ent : ents) {
                if (ent == null) continue;
                api.setEntityNoClip(ent, newValue);
            }
        }
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public String toString(Event e, boolean debug) {
        return "the no clip state of " + this.entities.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNoClip.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"no[( |-)]clip (state|mode) of %entities%", "%entities%'s no[( |-)]clip (state|mode)"});
    }
}

