/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.nbt.elements.objects.Bound;

@Name(value="Bounding Box Coords")
@Description(value={"The coords and world of a bounding box. You can get the world/coords for a specific bound, you can also set the coords of a bounding box. You can NOT set the world of a bounding box. ", "\nLesser will always equal the lower south-east corner. ", "Greater will always equal the higher north-west corner."})
@Examples(value={"set lesser y coord of {bound} to 10", "set {_x} to greater x coord of {bound}"})
@Since(value="2.6.0")
public class ExprBoundCoords
extends PropertyExpression<Bound, Object> {
    private boolean WORLD;
    private boolean LESSER;
    private int parse;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.WORLD = matchedPattern == 2;
        this.LESSER = matchedPattern == 0;
        this.parse = parseResult.mark;
        return true;
    }

    protected Object[] get(Event event, Bound[] bounds) {
        return this.get(bounds, (Converter)new Getter<Object, Bound>(){

            public Object get(Bound bound) {
                if (ExprBoundCoords.this.WORLD) {
                    return bound.getWorld();
                }
                switch (ExprBoundCoords.this.parse) {
                    case 0: {
                        return ExprBoundCoords.this.LESSER ? bound.getLesserX() : bound.getGreaterX();
                    }
                    case 1: {
                        return ExprBoundCoords.this.LESSER ? bound.getLesserY() : bound.getGreaterY();
                    }
                }
                return ExprBoundCoords.this.LESSER ? bound.getLesserZ() : bound.getGreaterZ();
            }
        });
    }

    public Class<?> getReturnType() {
        if (this.WORLD) {
            return World.class;
        }
        return Integer.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.WORLD && mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        block5: for (Bound bound : (Bound[])this.getExpr().getArray(e)) {
            int coord = ((Number)delta[0]).intValue();
            switch (this.parse) {
                case 0: {
                    if (this.LESSER) {
                        bound.setLesserX(coord);
                        continue block5;
                    }
                    bound.setGreaterX(coord);
                    continue block5;
                }
                case 1: {
                    if (this.LESSER) {
                        bound.setLesserY(coord);
                        continue block5;
                    }
                    bound.setGreaterY(coord);
                    continue block5;
                }
                case 2: {
                    if (this.LESSER) {
                        bound.setLesserZ(coord);
                        continue block5;
                    }
                    bound.setGreaterZ(coord);
                }
            }
        }
    }

    public String toString(Event e, boolean d) {
        String type = "";
        String lesser = "";
        if (this.WORLD) {
            type = "world";
        } else {
            if (this.LESSER) {
                lesser = "lesser ";
            }
            if (this.parse == 0) {
                type = "x coord";
            } else if (this.parse == 1) {
                type = "y coord";
            } else if (this.parse == 2) {
                type = "z coord";
            }
        }
        return lesser + type + " of bound " + this.getExpr().toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundCoords.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"lesser (0\u00a6x|1\u00a6y|2\u00a6z) coord[inate] of [bound] %bound%", "greater (0\u00a6x|1\u00a6y|2\u00a6z) coord[inate] of [bound] %bound%", "world of bound %bound%"});
    }
}

