/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;
import tk.shanebee.nbt.NBeeT;

public class Bound {
    private int x;
    private int y;
    private int z;
    private int x2;
    private int y2;
    private int z2;
    private String world;

    public Bound(String world, int x, int y, int z, int x2, int y2, int z2) {
        this.world = world;
        this.x = Math.min(x, x2);
        this.y = Math.min(y, y2);
        this.z = Math.min(z, z2);
        this.x2 = Math.max(x, x2);
        this.y2 = Math.max(y, y2);
        this.z2 = Math.max(z, z2);
        NBeeT.getInstance().getBounds().add(this);
    }

    public Bound(Location location, Location location2) {
        this(Objects.requireNonNull(location.getWorld()).getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), location2.getBlockX(), location2.getBlockY(), location2.getBlockZ());
    }

    public Bound(String string) {
        String[] coords = string.split(":");
        this.world = coords[0];
        this.x = Integer.parseInt(coords[1]);
        this.y = Integer.parseInt(coords[2]);
        this.z = Integer.parseInt(coords[3]);
        this.x2 = Integer.parseInt(coords[4]);
        this.y2 = Integer.parseInt(coords[5]);
        this.z2 = Integer.parseInt(coords[6]);
        NBeeT.getInstance().getBounds().add(this);
    }

    public boolean isInRegion(Location loc) {
        if (!Objects.requireNonNull(loc.getWorld()).getName().equals(this.world)) {
            return false;
        }
        int cx = loc.getBlockX();
        int cy = loc.getBlockY();
        int cz = loc.getBlockZ();
        return cx >= this.x && cx <= this.x2 && cy >= this.y && cy <= this.y2 && cz >= this.z && cz <= this.z2;
    }

    public ArrayList<Location> getBlocks(Material type) {
        World w = Bukkit.getWorld((String)this.world);
        ArrayList<Location> array = new ArrayList<Location>();
        for (int x3 = this.x; x3 <= this.x2; ++x3) {
            for (int y3 = this.y; y3 <= this.y2; ++y3) {
                for (int z3 = this.z; z3 <= this.z2; ++z3) {
                    assert (w != null);
                    Block b = w.getBlockAt(x3, y3, z3);
                    if (b.getType() != type) continue;
                    array.add(b.getLocation());
                }
            }
        }
        return array;
    }

    public List<Block> getBlocks() {
        World w = Bukkit.getWorld((String)this.world);
        ArrayList<Block> array = new ArrayList<Block>();
        for (int x3 = this.x; x3 <= this.x2; ++x3) {
            for (int y3 = this.y; y3 <= this.y2; ++y3) {
                for (int z3 = this.z; z3 <= this.z2; ++z3) {
                    assert (w != null);
                    Block b = w.getBlockAt(x3, y3, z3);
                    array.add(b);
                }
            }
        }
        return array;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    public String getWorldString() {
        return this.world;
    }

    public Location getGreaterCorner() {
        return new Location(Bukkit.getWorld((String)this.world), (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLesserCorner() {
        return new Location(Bukkit.getWorld((String)this.world), (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public Location getCenter() {
        BoundingBox box = new BoundingBox((double)this.x, (double)this.y, (double)this.z, (double)this.x2, (double)this.y2, (double)this.z2);
        return new Location(this.getWorld(), box.getCenterX(), box.getCenterY(), box.getCenterZ());
    }

    public int getLesserX() {
        return this.x;
    }

    public void setLesserX(int x) {
        this.x = x;
    }

    public int getLesserY() {
        return this.y;
    }

    public void setLesserY(int y) {
        this.y = y;
    }

    public int getLesserZ() {
        return this.z;
    }

    public void setLesserZ(int z) {
        this.z = z;
    }

    public int getGreaterX() {
        return this.x2;
    }

    public void setGreaterX(int x2) {
        this.x2 = x2;
    }

    public int getGreaterY() {
        return this.y2;
    }

    public void setGreaterY(int y2) {
        this.y2 = y2;
    }

    public int getGreaterZ() {
        return this.z2;
    }

    public void setGreaterZ(int z2) {
        this.z2 = z2;
    }

    public String toString() {
        return "" + this.world + ":" + this.x + ":" + this.y + ":" + this.z + ":" + this.x2 + ":" + this.y2 + ":" + this.z2;
    }
}

