/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.shynixn.structureblocklib.bukkit.api.StructureBlockApi;
import com.github.shynixn.structureblocklib.bukkit.api.business.service.PersistenceStructureService;
import com.github.shynixn.structureblocklib.bukkit.api.persistence.entity.StructureSaveConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

@Name(value="Structure Block: Save")
@Description(value={"Save structure block structures. 1.9.4+ ONLY"})
@Examples(value={"save structure between {loc1} and {loc2} as \"house\""})
@Since(value="2.2.0")
public class EffSaveStructure
extends Effect {
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.loc1 = exprs[0];
        this.loc2 = exprs[1];
        this.name = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        PersistenceStructureService service = StructureBlockApi.INSTANCE.getStructurePersistenceService();
        String world = ((World)Bukkit.getServer().getWorlds().get(0)).getName();
        StructureSaveConfiguration saveConfig = service.createSaveConfiguration("minecraft", (String)this.name.getSingle(event), world);
        service.save(saveConfig, (Location)this.loc1.getSingle(event), (Location)this.loc2.getSingle(event));
    }

    public String toString(Event e, boolean d) {
        return "save structure between " + this.loc1.toString(e, d) + " and " + this.loc2.toString(e, d) + " as " + this.name.toString(e, d);
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)9, (int)4)) {
            Skript.registerEffect(EffSaveStructure.class, (String[])new String[]{"save [structure] between %location% and %location% as %string%"});
        }
    }
}

