/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import tk.shanebee.nbt.elements.objects.Bound;

@Name(value="Bounding Box")
@Description(value={"Create a new 3D bounding box between 2 points. This could be useful for creating your own region system."})
@Examples(value={"set {bound} to bound between {loc1} and {loc2}"})
@Since(value="2.6.0")
public class ExprBound
extends SimpleExpression<Bound> {
    private Expression<Location> lesser;
    private Expression<Location> greater;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.lesser = expressions[0];
        this.greater = expressions[1];
        return true;
    }

    protected Bound[] get(Event event) {
        return (Bound[])CollectionUtils.array((Object[])new Bound[]{new Bound((Location)this.lesser.getSingle(event), (Location)this.greater.getSingle(event))});
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Bound> getReturnType() {
        return Bound.class;
    }

    public String toString(Event e, boolean d) {
        return "Bound between " + this.lesser.toString(e, d) + " and " + this.greater.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBound.class, Bound.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] [new] bound between %location% and %location%"});
    }
}

