/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.structureblocklib.bukkit.core;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public enum VersionSupport {
    VERSION_1_9_R1("v1_9_R1", "1.9.0", 1.091),
    VERSION_1_9_R2("v1_9_R2", "1.9.4", 1.092),
    VERSION_1_10_R1("v1_10_R1", "1.10.2", 1.1),
    VERSION_1_11_R1("v1_11_R1", "1.11.2", 1.11),
    VERSION_1_12_R1("v1_12_R1", "1.12.2", 1.12),
    VERSION_1_13_R1("v1_13_R1", "1.13.0", 1.13),
    VERSION_1_13_R2("v1_13_R2", "1.13.1", 1.131),
    VERSION_1_14_R1("v1_14_R1", "1.14.2", 1.142);

    private final String versionText;
    private final String simpleVersionText;
    private final double versionCode;

    private VersionSupport(String versionText, String simpleVersionText, double versionCode) {
        this.versionText = versionText;
        this.simpleVersionText = simpleVersionText;
        this.versionCode = versionCode;
    }

    public String getSimpleVersionText() {
        return this.simpleVersionText;
    }

    public String getVersionText() {
        return this.versionText;
    }

    public double getVersionCode() {
        return this.versionCode;
    }

    public boolean isVersionSameOrGreaterThan(VersionSupport versionSupport) {
        int result = Double.compare(this.versionCode, versionSupport.getVersionCode());
        return result == 0 || result == 1;
    }

    public boolean isVersionSameOrLowerThan(VersionSupport versionSupport) {
        int result = Double.compare(this.versionCode, versionSupport.getVersionCode());
        return result == 0 || result == -1;
    }

    public boolean isVersionGreaterThan(VersionSupport versionSupport) {
        int result = Double.compare(this.versionCode, versionSupport.getVersionCode());
        return result == 1;
    }

    public boolean isVersionLowerThan(VersionSupport versionSupport) {
        int result = Double.compare(this.versionCode, versionSupport.getVersionCode());
        return result == -1;
    }

    public static VersionSupport getGreatestVersionSupported() {
        VersionSupport version = null;
        for (VersionSupport versionSupport : VersionSupport.values()) {
            if (version != null && !versionSupport.isVersionGreaterThan(version)) continue;
            version = versionSupport;
        }
        return version;
    }

    public static VersionSupport getLowestVersionSupported() {
        VersionSupport version = null;
        for (VersionSupport versionSupport : VersionSupport.values()) {
            if (version != null && !versionSupport.isVersionLowerThan(version)) continue;
            version = versionSupport;
        }
        return version;
    }

    public static boolean isServerVersionSupported(String pluginName, String prefix) {
        if (VersionSupport.getServerVersion() == null) {
            Bukkit.getServer().getConsoleSender().sendMessage(prefix + ChatColor.RED + "================================================");
            Bukkit.getServer().getConsoleSender().sendMessage(prefix + ChatColor.RED + pluginName + " does not support your server version");
            Bukkit.getServer().getConsoleSender().sendMessage(prefix + ChatColor.RED + "Install v" + VersionSupport.getLowestVersionSupported().simpleVersionText + " - v" + VersionSupport.getGreatestVersionSupported().simpleVersionText);
            Bukkit.getServer().getConsoleSender().sendMessage(prefix + ChatColor.RED + "Plugin gets now disabled!");
            Bukkit.getServer().getConsoleSender().sendMessage(prefix + ChatColor.RED + "================================================");
            return false;
        }
        return true;
    }

    public static VersionSupport getServerVersion() {
        try {
            if (Bukkit.getServer() == null || Bukkit.getServer().getClass().getPackage() == null) {
                return null;
            }
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            for (VersionSupport versionSupport : VersionSupport.values()) {
                if (!versionSupport.getVersionText().equals(version)) continue;
                return versionSupport;
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to get server version.", e);
        }
        return null;
    }
}

