/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Item with CustomModelData")
@Description(value={"Give an item with a CustomModelData tag. (Value is an integer between 0 and 99999999) [1.14+ Only]"})
@Examples(value={"give player a diamond sword with custom model data 2", "set slot 1 of inventory of player to wooden hoe with custom model data 1"})
@Since(value="2.4.0")
public class ExprItemWithCustomModelData
extends PropertyExpression<ItemType, ItemType> {
    private Expression<Integer> data;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.data = exprs[1];
        return true;
    }

    protected ItemType[] get(Event e, ItemType[] source) {
        int data = (Integer)this.data.getSingle(e);
        return (ItemType[])this.get(source, item -> {
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(data));
            item.setItemMeta(meta);
            return item;
        });
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(Event e, boolean b) {
        return this.getExpr().toString(e, b) + " with custom model data " + this.data.toString(e, b);
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)14)) {
            Skript.registerExpression(ExprItemWithCustomModelData.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"%itemtype% with [custom] model data [tag] %integer%"});
        }
    }
}

