/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.structureblocklib.bukkit.core.business.service;

import com.github.shynixn.structureblocklib.bukkit.api.business.enumeration.StructureMirror;
import com.github.shynixn.structureblocklib.bukkit.api.business.enumeration.StructureRotation;
import com.github.shynixn.structureblocklib.bukkit.api.business.service.LocationCalculationService;
import com.github.shynixn.structureblocklib.bukkit.api.business.service.PersistenceStructureService;
import com.github.shynixn.structureblocklib.bukkit.api.persistence.entity.StructureSaveConfiguration;
import com.github.shynixn.structureblocklib.bukkit.core.VersionSupport;
import com.github.shynixn.structureblocklib.bukkit.core.persistence.entity.StructureSaveConfigurationEntity;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class PersistenceStructureServiceImpl
implements PersistenceStructureService {
    private final VersionSupport versionSupport = VersionSupport.getServerVersion();
    private final LocationCalculationService locationCalculationService;

    public PersistenceStructureServiceImpl(LocationCalculationService locationCalculationService) {
        this.locationCalculationService = locationCalculationService;
    }

    @Override
    public StructureSaveConfiguration createSaveConfiguration(String author, String saveName, String world) {
        return new StructureSaveConfigurationEntity(world, author, saveName);
    }

    @Override
    public void save(StructureSaveConfiguration saveConfiguration, Location source, Location corner) {
        Location lowerCorner = this.locationCalculationService.getDownCornerLocation(source, corner);
        Location upperCorner = this.locationCalculationService.getUpCornerLocation(source, corner);
        Vector offset = this.locationCalculationService.toDimensions(lowerCorner, upperCorner);
        this.save(saveConfiguration, lowerCorner, offset);
    }

    @Override
    public void save(StructureSaveConfiguration saveConfiguration, Location source, Vector offSet) {
        try {
            if (offSet.getBlockX() < 0) {
                source.setX(source.getX() + offSet.getX());
                offSet.setX(offSet.getBlockX() * -1);
            }
            if (offSet.getBlockY() < 0) {
                source.setY(source.getY() + offSet.getY());
                offSet.setY(offSet.getBlockY() * -1);
            }
            if (offSet.getBlockZ() < 0) {
                source.setZ(source.getZ() + offSet.getZ());
                offSet.setZ(offSet.getBlockZ() * -1);
            }
            Method craftWorldGetHandle = this.findClazz("org.bukkit.craftbukkit.VERSION.CraftWorld").getDeclaredMethod("getHandle", new Class[0]);
            Object nmsWorld = craftWorldGetHandle.invoke((Object)source.getWorld(), new Object[0]);
            Class<?> blockPositionClazz = this.findClazz("net.minecraft.server.VERSION.BlockPosition");
            Class<?> minecraftKeyClazz = this.findClazz("net.minecraft.server.VERSION.MinecraftKey");
            Object vPosition = blockPositionClazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0);
            Object finalBlockPosition = blockPositionClazz.getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.BaseBlockPosition")).invoke(vPosition, blockPositionClazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(source.getBlockX(), source.getBlockY(), source.getBlockZ()));
            Object finalSecondBlockPosition = blockPositionClazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(offSet.getBlockX() + 1, offSet.getBlockY() + 1, offSet.getBlockZ() + 1);
            World saveWorldBukkit = Bukkit.getWorld((String)saveConfiguration.getWorld());
            if (saveWorldBukkit == null) {
                throw new Exception("World " + saveConfiguration.getWorld() + " does not exist.");
            }
            Object saveWorld = craftWorldGetHandle.invoke((Object)saveWorldBukkit, new Object[0]);
            Object structureManager = this.findStructureManager(saveWorld);
            Object mineCraftServer = this.findClazz("net.minecraft.server.VERSION.World").getDeclaredMethod("getMinecraftServer", new Class[0]).invoke(saveWorld, new Object[0]);
            Object definedStructure = this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R1) ? this.findClazz("net.minecraft.server.VERSION.DefinedStructureManager").getDeclaredMethod("a", minecraftKeyClazz).invoke(structureManager, minecraftKeyClazz.getDeclaredConstructor(String.class, String.class).newInstance(saveConfiguration.getAuthor(), saveConfiguration.getSaveName())) : this.findClazz("net.minecraft.server.VERSION.DefinedStructureManager").getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.MinecraftServer"), minecraftKeyClazz).invoke(structureManager, mineCraftServer, minecraftKeyClazz.getDeclaredConstructor(String.class, String.class).newInstance(saveConfiguration.getAuthor(), saveConfiguration.getSaveName()));
            this.findClazz("net.minecraft.server.VERSION.DefinedStructure").getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.World"), blockPositionClazz, blockPositionClazz, Boolean.TYPE, this.findClazz("net.minecraft.server.VERSION.Block")).invoke(definedStructure, nmsWorld, finalBlockPosition, finalSecondBlockPosition, !saveConfiguration.isIgnoreEntities(), this.findClazz("net.minecraft.server.VERSION.Blocks").getDeclaredField("BARRIER").get(null));
            this.findClazz("net.minecraft.server.VERSION.DefinedStructure").getDeclaredMethod("a", String.class).invoke(definedStructure, saveConfiguration.getAuthor());
            if (this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R1)) {
                this.findClazz("net.minecraft.server.VERSION.DefinedStructureManager").getDeclaredMethod("c", minecraftKeyClazz).invoke(structureManager, minecraftKeyClazz.getDeclaredConstructor(String.class, String.class).newInstance(saveConfiguration.getAuthor(), saveConfiguration.getSaveName()));
                Bukkit.getLogger().log(Level.INFO, "[StructureBlockLib] Stored structure to ../" + saveWorldBukkit.getName() + "/generated/" + saveConfiguration.getAuthor() + "/structures/" + saveConfiguration.getSaveName() + ".nbt");
            } else {
                this.findClazz("net.minecraft.server.VERSION.DefinedStructureManager").getDeclaredMethod("c", this.findClazz("net.minecraft.server.VERSION.MinecraftServer"), minecraftKeyClazz).invoke(structureManager, mineCraftServer, minecraftKeyClazz.getDeclaredConstructor(String.class, String.class).newInstance(saveConfiguration.getAuthor(), saveConfiguration.getSaveName()));
                Bukkit.getLogger().log(Level.INFO, "[StructureBlockLib] Stored structure to ../" + saveWorldBukkit.getName() + "/structures/" + saveConfiguration.getSaveName() + ".nbt");
                try {
                    File sourceFile = new File(saveWorldBukkit.getName() + "/structures/" + saveConfiguration.getSaveName() + ".nbt");
                    File targetFile = new File(saveWorldBukkit.getName() + "/generated/" + saveConfiguration.getAuthor() + "/structures/" + saveConfiguration.getSaveName() + ".nbt");
                    FileUtils.copyFile((File)sourceFile, (File)targetFile);
                    Bukkit.getLogger().log(Level.INFO, "[StructureBlockLib] Stored 1.13 compatibility structure to ../" + saveWorldBukkit.getName() + "/generated/" + saveConfiguration.getAuthor() + "/structures/" + saveConfiguration.getSaveName() + ".nbt");
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.WARNING, "Failed to create compatibility structure copy.", ex);
                }
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to load structure.", ex);
        }
    }

    @Override
    public boolean load(StructureSaveConfiguration saveConfiguration, Location target) {
        try {
            if (!this.structureExists(saveConfiguration)) {
                return false;
            }
            Method craftWorldGetHandle = this.findClazz("org.bukkit.craftbukkit.VERSION.CraftWorld").getDeclaredMethod("getHandle", new Class[0]);
            Class<?> minecraftKeyClazz = this.findClazz("net.minecraft.server.VERSION.MinecraftKey");
            Object nmsWorld = craftWorldGetHandle.invoke((Object)target.getWorld(), new Object[0]);
            boolean isClientSideWorld = (Boolean)this.findClazz("net.minecraft.server.VERSION.World").getDeclaredField("isClientSide").get(nmsWorld);
            if (isClientSideWorld) {
                return false;
            }
            World saveWorldBukkit = Bukkit.getWorld((String)saveConfiguration.getWorld());
            if (saveWorldBukkit == null) {
                throw new Exception("World " + saveConfiguration.getWorld() + " does not exist.");
            }
            Object saveWorld = craftWorldGetHandle.invoke((Object)saveWorldBukkit, new Object[0]);
            Class<?> blockPositionClazz = this.findClazz("net.minecraft.server.VERSION.BlockPosition");
            Object vPosition = blockPositionClazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0);
            Object finalBlockPosition = blockPositionClazz.getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.BaseBlockPosition")).invoke(vPosition, blockPositionClazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(target.getBlockX(), target.getBlockY(), target.getBlockZ()));
            Object structureManager = this.findStructureManager(saveWorld);
            Object mineCraftServer = this.findClazz("net.minecraft.server.VERSION.World").getDeclaredMethod("getMinecraftServer", new Class[0]).invoke(nmsWorld, new Object[0]);
            Object definedStructure = this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R1) ? this.findClazz("net.minecraft.server.VERSION.DefinedStructureManager").getDeclaredMethod("a", minecraftKeyClazz).invoke(structureManager, minecraftKeyClazz.getDeclaredConstructor(String.class, String.class).newInstance(saveConfiguration.getAuthor(), saveConfiguration.getSaveName())) : this.findClazz("net.minecraft.server.VERSION.DefinedStructureManager").getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.MinecraftServer"), minecraftKeyClazz).invoke(structureManager, mineCraftServer, minecraftKeyClazz.getDeclaredConstructor(String.class, String.class).newInstance(saveConfiguration.getAuthor(), saveConfiguration.getSaveName()));
            Class<?> definedStructureInfoClazz = this.findClazz("net.minecraft.server.VERSION.DefinedStructureInfo");
            Class<?> mirrorClazz = this.findClazz("net.minecraft.server.VERSION.EnumBlockMirror");
            Class<?> rotationClazz = this.findClazz("net.minecraft.server.VERSION.EnumBlockRotation");
            Object definedStructureInfo = definedStructureInfoClazz.newInstance();
            definedStructureInfoClazz.getDeclaredMethod("a", mirrorClazz).invoke(definedStructureInfo, this.getBlockMirror(mirrorClazz, saveConfiguration.getMirror()));
            definedStructureInfoClazz.getDeclaredMethod("a", rotationClazz).invoke(definedStructureInfo, this.getBlockRotation(rotationClazz, saveConfiguration.getRotation()));
            definedStructureInfoClazz.getDeclaredMethod("a", Boolean.TYPE).invoke(definedStructureInfo, saveConfiguration.isIgnoreEntities());
            definedStructureInfoClazz.getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.ChunkCoordIntPair")).invoke(definedStructureInfo, new Object[]{null});
            definedStructureInfoClazz.getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.Block")).invoke(definedStructureInfo, new Object[]{null});
            if (this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R1)) {
                definedStructureInfoClazz.getDeclaredMethod("c", Boolean.TYPE).invoke(definedStructureInfo, false);
                this.findClazz("net.minecraft.server.VERSION.DefinedStructure").getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.GeneratorAccess"), blockPositionClazz, definedStructureInfoClazz).invoke(definedStructure, nmsWorld, finalBlockPosition, definedStructureInfo);
            } else {
                definedStructureInfoClazz.getDeclaredMethod("b", Boolean.TYPE).invoke(definedStructureInfo, false);
                this.findClazz("net.minecraft.server.VERSION.DefinedStructure").getDeclaredMethod("a", this.findClazz("net.minecraft.server.VERSION.World"), blockPositionClazz, definedStructureInfoClazz).invoke(definedStructure, nmsWorld, finalBlockPosition, definedStructureInfo);
            }
            return true;
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to load structure.", ex);
            return false;
        }
    }

    private Class<?> findClazz(String text) throws ClassNotFoundException {
        return Class.forName(text.replace("VERSION", this.versionSupport.getVersionText()));
    }

    private Object getBlockRotation(Class rotationClazz, StructureRotation rotation) {
        switch (rotation) {
            case NONE: {
                return Enum.valueOf(rotationClazz, "NONE");
            }
            case ROTATION_90: {
                return Enum.valueOf(rotationClazz, "CLOCKWISE_90");
            }
            case ROTATION_180: {
                return Enum.valueOf(rotationClazz, "CLOCKWISE_180");
            }
            case ROTATION_270: {
                return Enum.valueOf(rotationClazz, "COUNTERCLOCKWISE_90");
            }
        }
        return null;
    }

    private boolean structureExists(StructureSaveConfiguration configuration) {
        File file = this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R1) ? new File(configuration.getWorld() + File.separator + "generated" + File.separator + configuration.getAuthor() + File.separator + "structures" + File.separator + configuration.getSaveName() + ".nbt") : new File(configuration.getWorld() + File.separator + "structures" + File.separator + configuration.getSaveName() + ".nbt");
        return file.isFile();
    }

    private Object findStructureManager(Object saveWorld) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R2)) {
            return this.findClazz("net.minecraft.server.VERSION.WorldServer").getDeclaredMethod("D", new Class[0]).invoke(saveWorld, new Object[0]);
        }
        if (this.versionSupport.isVersionSameOrGreaterThan(VersionSupport.VERSION_1_13_R1)) {
            return this.findClazz("net.minecraft.server.VERSION.WorldServer").getDeclaredMethod("C", new Class[0]).invoke(saveWorld, new Object[0]);
        }
        return this.findClazz("net.minecraft.server.VERSION.WorldServer").getDeclaredMethod("y", new Class[0]).invoke(saveWorld, new Object[0]);
    }

    private Object getBlockMirror(Class mirrorClazz, StructureMirror mirror) {
        switch (mirror) {
            case NONE: {
                return Enum.valueOf(mirrorClazz, "NONE");
            }
            case FRONT_BACK: {
                return Enum.valueOf(mirrorClazz, "FRONT_BACK");
            }
            case LEFT_RIGHT: {
                return Enum.valueOf(mirrorClazz, "LEFT_RIGHT");
            }
        }
        return null;
    }
}

