/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.event.Event;

@Name(value="EntityBlockStorage - Max Entities")
@Description(value={"Get/Set the max amount of entities which can be stored in a block.", "As of 1.15 this only includes beehives/bee nests! Requires Spigot/Paper 1.15.2+"})
@Examples(value={"set {_m} to max entities of target block of player", "set max entities of target block of player to 20", "set max entity storage of event-block to 5"})
@Since(value="2.11.0")
public class ExprEntityBlockStorageMax
extends SimplePropertyExpression<Block, Long> {
    public Long convert(Block block) {
        BlockState state = block.getState();
        if (state instanceof EntityBlockStorage) {
            return ((EntityBlockStorage)state).getMaxEntities();
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET) {
            return new Class[]{Long.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        for (Block block : (Block[])this.getExpr().getArray(e)) {
            int change = delta == null ? this.getDefault(block) : ((Number)delta[0]).intValue();
            BlockState state = block.getState();
            if (!(state instanceof EntityBlockStorage)) continue;
            EntityBlockStorage storage = (EntityBlockStorage)state;
            int newVal = storage.getMaxEntities();
            switch (mode) {
                case RESET: 
                case SET: {
                    newVal = change;
                    break;
                }
                case ADD: {
                    newVal += change;
                    break;
                }
                case REMOVE: {
                    newVal -= change;
                }
            }
            storage.setMaxEntities(Math.max(1, newVal));
            storage.update(true, false);
        }
    }

    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    protected String getPropertyName() {
        return "max entities of entity storage block";
    }

    private int getDefault(Block block) {
        switch (block.getType().toString()) {
            case "BEEHIVE": 
            case "BEE_NEST": {
                return 3;
            }
        }
        return 0;
    }

    static {
        if (Skript.classExists((String)"org.bukkit.block.EntityBlockStorage")) {
            ExprEntityBlockStorageMax.register(ExprEntityBlockStorageMax.class, Long.class, (String)"max entit(ies|y storage)", (String)"blocks");
        }
    }
}

