/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="CustomModelData Tag")
@Description(value={"Set/get the CustomModelData tag for an item. (Value is an integer between 0 and 99999999) [1.14+ Only]"})
@Examples(value={"set custom model data tag of player's tool to 3", "set {_test} to custom model data of player's tool"})
@Since(value="2.4.0")
public class ExprCustomModelData
extends SimplePropertyExpression<ItemStack, Long> {
    static final /* synthetic */ boolean $assertionsDisabled;

    public Long convert(ItemStack itemStack) {
        if (itemStack.getItemMeta() == null) {
            return null;
        }
        if (itemStack.getItemMeta().hasCustomModelData()) {
            return itemStack.getItemMeta().getCustomModelData();
        }
        return 0L;
    }

    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
    }

    protected String getPropertyName() {
        return "custom model data";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (!(delta[0] instanceof Long) || (Long)delta[0] > 99999999L) {
            return;
        }
        long data = (Long)delta[0];
        long newData = 0L;
        long oldData = 0L;
        ItemMeta meta = ((ItemStack)this.getExpr().getSingle(e)).getItemMeta();
        if (!$assertionsDisabled && meta == null) {
            throw new AssertionError();
        }
        if (meta.hasCustomModelData()) {
            oldData = meta.getCustomModelData();
        }
        switch (mode) {
            case ADD: {
                newData = oldData + data;
                break;
            }
            case SET: {
                newData = data;
                break;
            }
            case REMOVE: {
                newData = oldData - data;
                break;
            }
        }
        meta.setCustomModelData(Integer.valueOf((int)newData));
        ((ItemStack)this.getExpr().getSingle(e)).setItemMeta(meta);
    }

    public String toString(Event e, boolean d) {
        return "custom model data of " + this.getExpr().toString(e, d);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprCustomModelData.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft((int)1, (int)14)) {
            ExprCustomModelData.register(ExprCustomModelData.class, Long.class, (String)"[custom] model data [tag]", (String)"itemstack");
        }
    }
}

