/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Block Data - Item")
@Description(value={"Get block data from an item. You can get a string of block data, all the tags in a block data or a specific tag. ", "You can also set a block data for an item or set a specific tag for block data. This syntax is only available for MC 1.14+"})
@Examples(value={"set item data of player's tool to block data of target block", "set item data of player's tool to \"minecraft:campfire[lit=false,waterlogged=true]\"", "set item data tag \"lit\" of player's tool to false"})
@Since(value="2.10.0")
public class ExprBlockDataItem
extends SimpleExpression<Object> {
    private Expression<String> tag;
    private Expression<ItemType> itemTypes;
    private int parse;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.tag = exprs[0];
        this.itemTypes = exprs[1];
        this.parse = parseResult.mark;
        return true;
    }

    protected Object[] get(Event event) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ItemType itemType : (ItemType[])this.itemTypes.getAll(event)) {
            ItemStack stack = itemType.getRandom();
            if (!(stack.getItemMeta() instanceof BlockDataMeta) || !((BlockDataMeta)stack.getItemMeta()).hasBlockData()) {
                return null;
            }
            BlockDataMeta meta = (BlockDataMeta)stack.getItemMeta();
            Material material = stack.getType();
            if (this.parse == 2) {
                String tag = this.getTag(meta.getBlockData(this.getBlockForm(material)).getAsString(), (String)this.tag.getSingle(event));
                if (tag == null) {
                    return null;
                }
                if (this.isBoolean(tag)) {
                    list.add(Boolean.valueOf(tag));
                    continue;
                }
                if (this.isNumber(tag)) {
                    list.add(Integer.parseInt(tag));
                    continue;
                }
                list.add(tag);
                continue;
            }
            if (this.parse == 1) {
                String[] data = this.getData(meta.getBlockData(this.getBlockForm(material)).getAsString());
                if (data == null) continue;
                list.addAll(Arrays.asList(data));
                continue;
            }
            list.add(meta.getBlockData(this.getBlockForm(material)).getAsString());
        }
        return list.toArray();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String obj = delta == null ? "" : delta[0].toString();
        block8: for (ItemType itemType : (ItemType[])this.itemTypes.getAll(e)) {
            switch (this.parse) {
                case 2: {
                    BlockDataMeta meta;
                    BlockData blockData;
                    String newData = this.getBlockForm(itemType.getMaterial()).getKey() + "[" + (String)this.tag.getSingle(e) + "=" + obj + "]";
                    try {
                        blockData = Bukkit.createBlockData((String)newData);
                        meta = (BlockDataMeta)itemType.getItemMeta();
                        BlockData oldData = !meta.hasBlockData() ? this.getBlockForm(itemType.getMaterial()).createBlockData() : meta.getBlockData(itemType.getMaterial());
                        blockData = oldData.merge(blockData);
                        meta.setBlockData(blockData);
                        itemType.setItemMeta((ItemMeta)meta);
                    }
                    catch (IllegalArgumentException ex) {
                        Skript.error((String)("Could not parse block data: " + newData), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    }
                    continue block8;
                }
                case 1: {
                    return;
                }
                default: {
                    BlockDataMeta meta;
                    BlockData blockData;
                    try {
                        blockData = Bukkit.createBlockData((String)obj);
                        meta = (BlockDataMeta)itemType.getItemMeta();
                        meta.setBlockData(blockData);
                        itemType.setItemMeta((ItemMeta)meta);
                        continue block8;
                    }
                    catch (IllegalArgumentException ex) {
                        Skript.error((String)("Could not parse block data: " + obj), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    }
                }
            }
        }
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return this.parse != 1;
    }

    public String toString(Event e, boolean d) {
        return "item block data" + (this.parse == 1 ? " tags" : (this.parse == 2 ? " tag " + this.tag.toString(e, d) : "")) + " of item " + this.itemTypes.toString(e, d);
    }

    private String getTag(String data, String tag) {
        String[] sp = this.getData(data);
        if (sp != null) {
            for (String string : sp) {
                String[] s = string.split("=");
                if (!s[0].equals(tag)) continue;
                return s[1];
            }
        }
        return null;
    }

    private String[] getData(String data) {
        String[] splits1 = data.split("\\[");
        if (splits1.length >= 2) {
            String[] splits2 = splits1[1].split("]");
            return splits2[0].split(",");
        }
        return null;
    }

    private boolean isNumber(String string) {
        return string.matches("\\d+");
    }

    private boolean isBoolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
    }

    private Material getBlockForm(Material item) {
        if (item.isBlock()) {
            return item;
        }
        switch (item) {
            case WHEAT_SEEDS: {
                return Material.WHEAT;
            }
            case POTATO: {
                return Material.POTATOES;
            }
            case CARROT: {
                return Material.CARROTS;
            }
            case BEETROOT_SEEDS: {
                return Material.BEETROOTS;
            }
            case PUMPKIN_SEEDS: {
                return Material.PUMPKIN_STEM;
            }
            case MELON_SEEDS: {
                return Material.MELON_STEM;
            }
            case SWEET_BERRIES: {
                return Material.SWEET_BERRY_BUSH;
            }
        }
        return item;
    }

    static {
        if (Skript.classExists((String)"org.bukkit.inventory.meta.BlockDataMeta")) {
            PropertyExpression.register(ExprBlockDataItem.class, Object.class, (String)"item [block[ ]]data [(1\u00a6tags|2\u00a6tag %-string%)]", (String)"itemtypes");
        }
    }
}

