/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.event.Event;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.elements.objects.Bound;

@Name(value="Bound - At Location")
@Description(value={"Get a list of bounds/ids at a location."})
@Examples(value={"set {_bounds::*} to bounds at player", "set {_b::*} to bound ids at player", "loop all bounds at player:"})
@Since(value="2.9.3")
public class ExprBoundAtLocation
extends SimpleExpression<Object> {
    private Expression<Location> location;
    private boolean ID;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.location = exprs[0];
        this.ID = pattern == 1;
        return true;
    }

    protected Object[] get(Event event) {
        if (this.location == null) {
            return null;
        }
        Location loc = (Location)this.location.getSingle(event);
        if (this.ID) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Bound bound : NBeeT.getInstance().getBoundConfig().getBounds()) {
                if (!bound.isInRegion(loc)) continue;
                ids.add(bound.getId());
            }
            return ids.toArray(new String[0]);
        }
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        for (Bound bound : NBeeT.getInstance().getBoundConfig().getBounds()) {
            if (!bound.isInRegion(loc)) continue;
            bounds.add(bound);
        }
        return bounds.toArray(new Bound[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<?> getReturnType() {
        if (this.ID) {
            return String.class;
        }
        return Bound.class;
    }

    public String toString(Event e, boolean d) {
        return "bound" + (this.ID ? " ids" : "s at location " + this.location.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprBoundAtLocation.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(all [[of] the]|the)] bound[s] at %location%", "[(all [[of] the]|the)] bound id[s] at %location%"});
    }
}

