/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.config;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.elements.objects.Bound;

public class BoundConfig {
    private NBeeT plugin;
    private File boundFile;
    private FileConfiguration boundConfig;
    private Map<String, Bound> boundsMap = new HashMap<String, Bound>();

    public BoundConfig(NBeeT plugin) {
        this.plugin = plugin;
        this.loadBoundConfig();
    }

    private void loadBoundConfig() {
        if (this.boundFile == null) {
            this.boundFile = new File(this.plugin.getDataFolder(), "bounds.yml");
        }
        if (!this.boundFile.exists()) {
            this.plugin.saveResource("bounds.yml", false);
        }
        this.boundConfig = YamlConfiguration.loadConfiguration((File)this.boundFile);
        this.loadBounds();
    }

    private void loadBounds() {
        ConfigurationSection section = this.boundConfig.getConfigurationSection("bounds");
        if (section == null) {
            return;
        }
        for (String string : section.getKeys(true)) {
            if (!(section.get(string) instanceof Bound)) continue;
            this.boundsMap.put(string, (Bound)section.get(string));
        }
    }

    public void saveBound(Bound bound) {
        this.boundConfig.set("bounds." + bound.getId(), (Object)bound);
        this.boundsMap.put(bound.getId(), bound);
        this.saveConfig();
    }

    public void removeBound(Bound bound) {
        this.boundsMap.remove(bound.getId());
        this.boundConfig.set("bounds." + bound.getId(), null);
        this.saveConfig();
    }

    public Bound getBoundFromID(String id) {
        if (this.boundsMap.containsKey(id)) {
            return this.boundsMap.get(id);
        }
        return null;
    }

    public void saveAllBounds() {
        for (Bound bound : this.boundsMap.values()) {
            this.saveBound(bound);
        }
    }

    private void saveConfig() {
        try {
            this.boundConfig.save(this.boundFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<Bound> getBounds() {
        return this.boundsMap.values();
    }
}

