/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.nms.NBTApi;

@Name(value="NBT - Item/Entity/Block")
@Description(value={"NBT of items, entities or tile entities (such as a furnace, hopper, brewing stand, banner, etc) Supports get, set, add and reset. Reset will only properly work on an item, not entities or blocks"})
@Examples(value={"set {_nbt} to nbt of player's tool", "add \"{Enchantments:[{id:\"\"sharpness\"\",lvl:5}]}\" to nbt of player's tool", "reset nbt of player's tool", "set {_nbt} to nbt of target entity", "set {_nbt} to event-entity", "add \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&bMyNewName\\\"\"}\"\"}\" to target entity", "add \"{RequiredPlayerRange:0s}\" to targeted block's nbt", "add \"{SpawnData:{id:\"\"minecraft:wither\"\"}}\" to nbt of clicked block"})
@Since(value="2.0.0")
public class ExprObjectNBT
extends SimplePropertyExpression<Object, String> {
    @Nullable
    public String convert(Object o) {
        NBTApi api = NBeeT.getNBTApi();
        if (o instanceof ItemType) {
            return api.getNBT((ItemType)o);
        }
        if (o instanceof Entity) {
            return api.getNBT((Entity)o);
        }
        if (o instanceof Block) {
            return api.getNBT((Block)o);
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Object o = this.getExpr().getSingle(event);
        String value = delta != null ? (String)delta[0] : "{}";
        NBTApi api = NBeeT.getNBTApi();
        switch (mode) {
            case ADD: {
                if (o instanceof ItemType) {
                    api.addNBT((ItemType)o, value);
                    break;
                }
                if (o instanceof Entity) {
                    api.addNBT((Entity)o, value);
                    break;
                }
                if (!(o instanceof Block)) break;
                api.addNBT((Block)o, value);
                break;
            }
            case SET: 
            case RESET: {
                if (o instanceof ItemType) {
                    api.setNBT((ItemType)o, value);
                    break;
                }
                if (o instanceof Entity) {
                    api.setNBT((Entity)o, value);
                    break;
                }
                if (!(o instanceof Block)) break;
                api.setNBT((Block)o, value);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    protected String getPropertyName() {
        return "object nbt";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprObjectNBT.register(ExprObjectNBT.class, String.class, (String)"[(entity|item|block|tile[(-| )]entity)(-| )]nbt", (String)"block/entity/itemtype");
    }
}

