/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import tk.shanebee.nbt.NBeeT;
import tk.shanebee.nbt.nms.NBTApi;

@Name(value="NBT - Joined")
@Description(value={"Joins two different NBTs together. The latter value will overwrite conflicting values between the two."})
@Examples(value={"set {_ex} to joined nbt from \"{Test:false,Whatever:123}\" and \"{Something:something,Test:true}\""})
@Since(value="1.0.0")
public class ExprJoinedNBT
extends SimpleExpression<String> {
    private Expression<String> a;
    private Expression<String> b;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.a = expressions[0];
        this.b = expressions[1];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        NBTApi api = NBeeT.getNBTApi();
        String o = (String)this.a.getSingle(e);
        String j = (String)this.b.getSingle(e);
        return api.getJoinedNBT(o, j);
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "Joined NBT";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        Skript.registerExpression(ExprJoinedNBT.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"joined nbt[( |-)string] from %string% and %string%"});
    }
}

