/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.event.Event;

@Name(value="Skull Owner of Block")
@Description(value={"Sets the owner of a skull block"})
@Examples(value={"set skull owner of target block to player", "set skull owner of block at player to \"ShaneBee\" parsed as offline player"})
@Since(value="1.2.3")
public class ExprOwnerOfSkullBlock
extends SimplePropertyExpression<Block, OfflinePlayer> {
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        return null;
    }

    @Nullable
    public OfflinePlayer convert(Block block) {
        BlockState state = block.getState();
        if (state instanceof Skull) {
            Skull skull = (Skull)state;
            return skull.getOwningPlayer();
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Block block = (Block)this.getExpr().getSingle(e);
        if (block == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            OfflinePlayer player = (OfflinePlayer)delta[0];
            BlockState state = block.getState();
            if ((block.getType() == Material.PLAYER_HEAD || block.getType() == Material.PLAYER_WALL_HEAD) && state instanceof Skull) {
                Skull skull = (Skull)state;
                skull.setOwningPlayer(player);
                skull.update();
            }
        }
    }

    protected String getPropertyName() {
        return "skull owner of block";
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    static {
        ExprOwnerOfSkullBlock.register(ExprOwnerOfSkullBlock.class, OfflinePlayer.class, (String)"skull( |-)owner", (String)"block");
    }
}

