/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.MojangsonParser;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="NBT - Item")
@Description(value={"NBT of an item. Supports get, set, add, delete and reset"})
@Examples(value={"add \"{Enchantments:[{id:\"\"sharpness\"\",lvl:1}]}\" to item-nbt of player's tool", "set item-nbt of command sender's chestplate to \"{Yes:false,No:true}\""})
@Since(value="1.0.0")
public class ExprItemNBT
extends SimplePropertyExpression<ItemType, String> {
    @Nullable
    public String convert(ItemType i) {
        if (i == null || i.getMaterial() == Material.AIR) {
            return null;
        }
        NBTTagCompound nbt = CraftItemStack.asNMSCopy((ItemStack)i.getRandom()).getTag();
        if (nbt == null) {
            return null;
        }
        return nbt.toString();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ItemType i = (ItemType)this.getExpr().getSingle(e);
        if (i != null && i.getMaterial() != Material.AIR) {
            net.minecraft.server.v1_13_R2.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)i.getRandom());
            switch (mode) {
                case ADD: {
                    NBTTagCompound nbt = new NBTTagCompound();
                    if (nms.getTag() != null) {
                        nbt = nms.getTag();
                    }
                    try {
                        NBTTagCompound nbtv = MojangsonParser.parse((String)((String)delta[0]));
                        nbt.a(nbtv);
                        nms.setTag(nbt);
                    }
                    catch (CommandSyntaxException ex) {
                        Skript.warning((String)("NBT parse error: " + ex.getMessage()));
                    }
                    break;
                }
                case REMOVE: {
                    if (nms.getTag() == null) {
                        return;
                    }
                    NBTTagCompound nbt = nms.getTag();
                    nbt.remove((String)delta[0]);
                    nms.setTag(nbt);
                    break;
                }
                case SET: {
                    try {
                        nms.setTag(MojangsonParser.parse((String)((String)delta[0])));
                    }
                    catch (CommandSyntaxException ex) {
                        Skript.warning((String)("NBT parse error: " + ex.getMessage()));
                    }
                    break;
                }
                case DELETE: 
                case RESET: {
                    nms.setTag(new NBTTagCompound());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            i.setItemMeta(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)nms).getItemMeta());
        }
    }

    protected String getPropertyName() {
        return "itemtype nbt";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprItemNBT.register(ExprItemNBT.class, String.class, (String)"[item[stack]( |-)]nbt", (String)"itemtype");
    }
}

