/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Hidden Item Flags")
@Description(value={"Hides the item flags on items, allowing you to make super duper custom items."})
@Examples(value={"set player's tool to player's tool with attribute flag hidden", "give player 1 diamond sword of sharpness 5 with enchants flag hidden", "set {_tool} to player's tool with all flags hidden", "give player potion of harming with potion effects flag hidden"})
@Since(value="1.2.1")
public class ExprHiddenFlags
extends SimplePropertyExpression<ItemStack, ItemStack> {
    private int parse = 5;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.parse = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    protected String getPropertyName() {
        return "Hidden Item Flags";
    }

    @Nullable
    public ItemStack convert(ItemStack item) {
        ItemStack i = item.clone();
        ItemMeta meta = i.getItemMeta();
        switch (this.parse) {
            case 0: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                break;
            }
            case 1: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                break;
            }
            case 2: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                break;
            }
            case 3: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                break;
            }
            case 4: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                break;
            }
            case 5: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            }
        }
        i.setItemMeta(meta);
        return i;
    }

    static {
        Skript.registerExpression(ExprHiddenFlags.class, ItemStack.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"%itemstacks% with (0\u00a6attribute[s]|1\u00a6enchant[s]|2\u00a6destroy[s]|3\u00a6potion[ ]effect[s]|4\u00a6unbreakable|5\u00a6all) flag[s] hidden"});
    }
}

