/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R1.MojangsonParser;
import net.minecraft.server.v1_13_R1.NBTTagCompound;
import org.bukkit.event.Event;

@Name(value="NBT - Tag")
@Description(value={"Returns the value of the specified tag of the specified NBT"})
@Examples(value={"set {_tag} to tag \"Invulnerable\" of targeted entity's nbt"})
public class ExprTagOfNBT
extends SimpleExpression<String> {
    private Expression<String> a;
    private Expression<String> b;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.a = expressions[0];
        this.b = expressions[1];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        String t = (String)this.a.getSingle(e);
        String n = (String)this.b.getSingle(e);
        if (t == null || n == null) {
            return null;
        }
        try {
            NBTTagCompound nbt = MojangsonParser.parse((String)n);
            if (nbt.get(t) != null) {
                return new String[]{nbt.get(t).toString()};
            }
            return null;
        }
        catch (CommandSyntaxException ex) {
            Skript.warning((String)("NBT parse error: " + ex.getMessage()));
            return null;
        }
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "Tag of NBT";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        Skript.registerExpression(ExprTagOfNBT.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"tag %string% of %string%"});
    }
}

