/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R1.MojangsonParser;
import net.minecraft.server.v1_13_R1.NBTTagCompound;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_13_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="NBT - Item")
@Description(value={"NBT of an item"})
@Examples(value={"add \"{SomeTag:1234}\" to player's tool's item-nbt", "set nbt of command sender's chestplate to \"{Yes:false,No:true}\""})
public class ExprItemNBT
extends SimplePropertyExpression<ItemStack, String> {
    @Nullable
    public String convert(ItemStack i) {
        if (i == null || i.getType() == Material.AIR) {
            return null;
        }
        NBTTagCompound nbt = CraftItemStack.asNMSCopy((ItemStack)i).getTag();
        if (nbt == null) {
            return null;
        }
        return nbt.toString();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ItemStack i = (ItemStack)this.getExpr().getSingle(e);
        if (i != null || i.getType() != Material.AIR) {
            net.minecraft.server.v1_13_R1.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)i);
            switch (mode) {
                case ADD: {
                    NBTTagCompound nbt = new NBTTagCompound();
                    if (nms.getTag() != null) {
                        nbt = nms.getTag();
                    }
                    try {
                        NBTTagCompound nbtv = MojangsonParser.parse((String)((String)delta[0]));
                        nbt.a(nbtv);
                        nms.setTag(nbt);
                    }
                    catch (CommandSyntaxException ex) {
                        Skript.warning((String)("NBT parse error: " + ex.getMessage()));
                    }
                    break;
                }
                case REMOVE: {
                    if (nms.getTag() == null) {
                        return;
                    }
                    NBTTagCompound nbt = nms.getTag();
                    nbt.remove((String)delta[0]);
                    nms.setTag(nbt);
                    break;
                }
                case SET: {
                    try {
                        nms.setTag(MojangsonParser.parse((String)((String)delta[0])));
                    }
                    catch (CommandSyntaxException ex) {
                        Skript.warning((String)("NBT parse error: " + ex.getMessage()));
                    }
                    break;
                }
                case DELETE: 
                case RESET: {
                    nms.setTag(new NBTTagCompound());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            i.setItemMeta(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R1.ItemStack)nms).getItemMeta());
        }
    }

    protected String getPropertyName() {
        return "itemstack nbt";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprItemNBT.register(ExprItemNBT.class, String.class, (String)"[item[stack]( |-)]nbt", (String)"itemstack");
    }
}

